/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.IOException;
import java.util.concurrent.ThreadLocalRandom;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpCondJump;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;

public class JumpNSample
extends OpCondJump {
    private static final ThreadLocalRandom f_rnd = ThreadLocalRandom.current();
    private transient int m_nEvery;

    public JumpNSample(Argument arg, Op op) {
        super(arg, op);
    }

    public JumpNSample(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
    }

    @Override
    public int getOpCode() {
        return 139;
    }

    @Override
    protected int completeUnaryOp(Frame frame, int iPC, ObjectHandle hValue) {
        int nEvery = this.m_nEvery;
        if (nEvery == 0) {
            long lEvery = ((ObjectHandle.JavaLong)hValue).getValue();
            this.m_nEvery = nEvery = Math.max(1, Math.min(Integer.MAX_VALUE, (int)lEvery));
        }
        return f_rnd.nextInt(nEvery) == 0 ? iPC + 1 : JumpNSample.jump(frame, iPC + this.m_ofJmp, this.m_cExits);
    }
}

