/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpCondJump;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template._native.reflect.xRTType;

public class JumpNType
extends OpCondJump {
    public JumpNType(Argument arg1, Argument arg2, Op op) {
        super(arg1, arg2, op);
    }

    public JumpNType(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
    }

    @Override
    public int getOpCode() {
        return 135;
    }

    @Override
    protected boolean hasSecondArgument() {
        return true;
    }

    @Override
    protected int completeUnaryOp(Frame frame, int iPC, ObjectHandle hValue) {
        TypeConstant typeTest;
        if (this.m_nArg2 <= -16) {
            typeTest = frame.resolveType(this.m_nArg2);
        } else {
            try {
                xRTType.TypeHandle hType = (xRTType.TypeHandle)frame.getArgument(this.m_nArg2);
                typeTest = hType.getUnsafeDataType();
            }
            catch (ClassCastException e) {
                return JumpNType.jump(frame, iPC + this.m_ofJmp, this.m_cExits);
            }
            catch (ObjectHandle.ExceptionHandle.WrapperException e) {
                return frame.raiseException(e);
            }
        }
        return hValue.getUnsafeType().isA(typeTest) ? iPC + 1 : JumpNType.jump(frame, iPC + this.m_ofJmp, this.m_cExits);
    }
}

