/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Op;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.OpSwitch;
import org.xvm.runtime.ConstHeap;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.xBoolean;
import org.xvm.util.Handy;

public class JumpVal
extends OpSwitch {
    protected int m_nArgCond;
    private Argument m_argCond;
    protected transient ObjectHandle[] m_ahCase;
    private transient Map<ObjectHandle, Integer> m_mapJump;
    private transient OpSwitch.Algorithm m_algorithm;
    private transient TypeConstant m_typeCond;
    private transient List<Object[]> m_listRanges;
    private static final int EXCLUDE_MASK = -1073741824;
    private static final int LO_EX = Integer.MIN_VALUE;
    private static final int HI_EX = 0x40000000;

    public JumpVal(Argument argCond, Constant[] aConstCase, Op[] aOpCase, Op opDefault) {
        super(aConstCase, aOpCase, opDefault);
        this.m_argCond = argCond;
    }

    public JumpVal(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nArgCond = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argCond != null) {
            this.m_nArgCond = JumpVal.encodeArgument(this.m_argCond, registry);
        }
        Handy.writePackedLong(out, this.m_nArgCond);
    }

    @Override
    public int getOpCode() {
        return 141;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hValue = frame.getArgument(this.m_nArgCond);
            return JumpVal.isDeferred(hValue) ? hValue.proceed(frame, frameCaller -> this.ensureJumpMap(frame, iPC, frameCaller.popStack())) : this.ensureJumpMap(frame, iPC, hValue);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int ensureJumpMap(Frame frame, int iPC, ObjectHandle hValue) {
        return this.m_algorithm == null ? this.explodeConstants(frame, iPC, hValue) : this.complete(frame, iPC, hValue);
    }

    protected int explodeConstants(Frame frame, int iPC, ObjectHandle hValue) {
        ObjectHandle[] ahCase = new ObjectHandle[this.m_aofCase.length];
        int cRows = this.m_aofCase.length;
        for (int iRow = 0; iRow < cRows; ++iRow) {
            ahCase[iRow] = frame.getConstHandle(this.m_anConstCase[iRow]);
        }
        if (Op.anyDeferred(ahCase)) {
            Frame.Continuation stepNext = frameCaller -> {
                this.buildJumpMap(frameCaller, ahCase);
                return this.complete(frameCaller, iPC, hValue);
            };
            return new Utils.GetArguments(ahCase, stepNext).doNext(frame);
        }
        this.buildJumpMap(frame, ahCase);
        return this.complete(frame, iPC, hValue);
    }

    protected int complete(Frame frame, int iPC, ObjectHandle hValue) {
        Integer Index;
        Map<ObjectHandle, Integer> mapJump = this.m_mapJump;
        switch (this.m_algorithm) {
            case NativeSimple: {
                Index = mapJump.get(hValue);
                break;
            }
            case NativeRange: {
                Index = mapJump.get(hValue);
                if (!hValue.isNativeEqual()) break;
                List<Object[]> listRanges = this.m_listRanges;
                for (Object[] ao : listRanges) {
                    int index = (Integer)ao[2];
                    boolean fLoEx = (index & Integer.MIN_VALUE) != 0;
                    boolean fHiEx = (index & 0x40000000) != 0;
                    if (Index != null && Index <= (index &= 0x3FFFFFFF)) continue;
                    ObjectHandle hLow = (ObjectHandle)ao[0];
                    ObjectHandle hHigh = (ObjectHandle)ao[1];
                    int nCmpLo = hValue.compareTo(hLow);
                    int nCmpHi = hValue.compareTo(hHigh);
                    if (!(fLoEx ? nCmpLo > 0 : nCmpLo >= 0) || !(fHiEx ? nCmpHi < 0 : nCmpHi <= 0)) continue;
                    return JumpVal.jump(frame, iPC + this.m_aofCase[index], this.m_acExits[index]);
                }
                break;
            }
            default: {
                return this.findNatural(frame, iPC, hValue, 0);
            }
        }
        return Index == null ? JumpVal.jump(frame, iPC + this.m_ofDefault, this.m_cDefaultExits) : JumpVal.jump(frame, iPC + this.m_aofCase[Index], this.m_acExits[Index]);
    }

    protected int findNatural(Frame frame, int iPC, ObjectHandle hValue, int iCase) {
        ObjectHandle[] ahCase = this.m_ahCase;
        int cCases = ahCase.length;
        while (iCase < cCases) {
            ObjectHandle hCase = ahCase[iCase];
            int iCurrent = iCase;
            block0 : switch (this.m_algorithm) {
                case NaturalRange: {
                    if (hCase.getType().isA(frame.poolContext().typeRange())) {
                        ObjectHandle.GenericHandle hRange = (ObjectHandle.GenericHandle)hCase;
                        ObjectHandle hLo = hRange.getField(null, "lowerBound");
                        ObjectHandle hHi = hRange.getField(null, "upperBound");
                        xBoolean.BooleanHandle hLoEx = (xBoolean.BooleanHandle)hRange.getField(null, "lowerExclusive");
                        xBoolean.BooleanHandle hHiEx = (xBoolean.BooleanHandle)hRange.getField(null, "upperExclusive");
                        Frame.Continuation stepNext = frameCaller -> this.findNatural(frameCaller, iPC, hValue, iCurrent + 1);
                        switch (this.checkRange(frame, this.m_typeCond, hValue, hLo, hHi, hLoEx.get(), hHiEx.get(), true, stepNext)) {
                            case -1: {
                                if (frame.popStack() != xBoolean.TRUE) break block0;
                                return JumpVal.jump(frame, iPC + this.m_aofCase[iCase], this.m_acExits[iCase]);
                            }
                            case -5: {
                                frame.m_frameNext.addContinuation(frameCaller -> frameCaller.popStack() == xBoolean.TRUE ? JumpVal.jump(frameCaller, iPC + this.m_aofCase[iCurrent], this.m_acExits[iCurrent]) : this.findNatural(frameCaller, iPC, hValue, iCurrent + 1));
                                return -5;
                            }
                            case -3: {
                                return -3;
                            }
                        }
                        throw new IllegalStateException();
                    }
                }
                case NaturalSimple: {
                    switch (this.m_typeCond.callEquals(frame, hValue, hCase, -1)) {
                        case -1: {
                            if (frame.popStack() != xBoolean.TRUE) break block0;
                            return JumpVal.jump(frame, iPC + this.m_aofCase[iCase], this.m_acExits[iCase]);
                        }
                        case -5: {
                            frame.m_frameNext.addContinuation(frameCaller -> frameCaller.popStack() == xBoolean.TRUE ? JumpVal.jump(frameCaller, iPC + this.m_aofCase[iCurrent], this.m_acExits[iCurrent]) : this.findNatural(frameCaller, iPC, hValue, iCurrent + 1));
                            return -5;
                        }
                        case -3: {
                            return -3;
                        }
                    }
                    throw new IllegalStateException();
                }
            }
            ++iCase;
        }
        return JumpVal.jump(frame, iPC + this.m_ofDefault, this.m_cDefaultExits);
    }

    private synchronized void buildJumpMap(Frame frame, ObjectHandle[] ahCase) {
        if (this.m_algorithm != null) {
            return;
        }
        int cCases = ahCase.length;
        HashMap<ObjectHandle, Integer> mapJump = new HashMap<ObjectHandle, Integer>(cCases);
        OpSwitch.Algorithm algorithm = OpSwitch.Algorithm.NativeSimple;
        TypeConstant typeCond = frame.getLocalType(this.m_nArgCond, null);
        TypeConstant typeRange = frame.poolContext().typeRange();
        ConstHeap heap = frame.f_context.f_container.f_heap;
        ConstantPool poolTarget = frame.f_function.getConstantPool();
        for (int iCase = 0; iCase < cCases; ++iCase) {
            TypeConstant typeCase;
            boolean fRange;
            ObjectHandle hCase = ahCase[iCase];
            assert (!hCase.isMutable());
            if (hCase.getComposition().getConstantPool() != poolTarget) {
                hCase = heap.relocateConst(hCase, frame.getConstant(this.m_anConstCase[iCase]));
                assert (hCase != null);
                ahCase[iCase] = hCase;
            }
            boolean bl = fRange = (typeCase = hCase.getType()).isA(typeRange) && !typeCond.isA(typeRange);
            if (algorithm.isNative()) {
                if (hCase.isNativeEqual()) {
                    mapJump.put(hCase, iCase);
                    continue;
                }
                if (fRange) {
                    if (this.addRange((ObjectHandle.GenericHandle)hCase, iCase)) {
                        algorithm = OpSwitch.Algorithm.NativeRange;
                        continue;
                    }
                    algorithm = OpSwitch.Algorithm.NaturalRange;
                    continue;
                }
                algorithm = OpSwitch.Algorithm.NaturalSimple;
                continue;
            }
            if (fRange) {
                algorithm = OpSwitch.Algorithm.NaturalRange;
                this.addRange((ObjectHandle.GenericHandle)hCase, iCase);
                continue;
            }
            algorithm = algorithm.worstOf(OpSwitch.Algorithm.NaturalSimple);
            mapJump.put(hCase, iCase);
        }
        this.m_ahCase = ahCase;
        this.m_mapJump = mapJump;
        this.m_algorithm = algorithm;
        this.m_typeCond = typeCond;
    }

    private boolean addRange(ObjectHandle.GenericHandle hRange, int index) {
        ObjectHandle hLo = hRange.getField(null, "lowerBound");
        ObjectHandle hHi = hRange.getField(null, "upperBound");
        xBoolean.BooleanHandle hLoEx = (xBoolean.BooleanHandle)hRange.getField(null, "lowerExclusive");
        xBoolean.BooleanHandle hHiEx = (xBoolean.BooleanHandle)hRange.getField(null, "upperExclusive");
        List<Object[]> list = this.m_listRanges;
        if (list == null) {
            list = this.m_listRanges = new ArrayList<Object[]>();
        }
        assert ((index & 0xC0000000) == 0);
        if (hLoEx.get()) {
            index |= Integer.MIN_VALUE;
        }
        if (hHiEx.get()) {
            index |= 0x40000000;
        }
        list.add(new Object[]{hLo, hHi, index});
        return hLo.isNativeEqual();
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        this.m_argCond = this.m_argCond.registerConstants(registry);
        super.registerConstants(registry);
    }

    @Override
    protected void appendArgDescription(StringBuilder sb) {
        sb.append(Argument.toIdString(this.m_argCond, this.m_nArgCond)).append(", ");
    }
}

