/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Op;
import org.xvm.asm.constants.ArrayConstant;
import org.xvm.asm.constants.MatchAnyConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.asm.op.OpSwitch;
import org.xvm.runtime.ConstHeap;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTType;
import org.xvm.runtime.template.xBoolean;
import org.xvm.util.Handy;

public class JumpVal_N
extends OpSwitch {
    private int[] m_anArgCond;
    private final long m_afIsSwitch;
    private Argument[] m_aArgCond;
    private transient ObjectHandle[][] m_aahCases;
    private transient TypeConstant[] m_atypeColumn;
    private transient Map<ObjectHandle, Long>[] m_amapJumpSmall;
    private transient long[] m_alWildcardSmall;
    private transient List<Object[]>[] m_alistRangeSmall;
    private transient OpSwitch.Algorithm[] m_aAlgorithm;
    private transient OpSwitch.Algorithm m_algorithm;

    public JumpVal_N(Argument[] aArgVal, long afIsSwitch, Constant[] aConstCase, Op[] aOpCase, Op opDefault) {
        super(aConstCase, aOpCase, opDefault);
        this.m_aArgCond = aArgVal;
        this.m_afIsSwitch = afIsSwitch;
    }

    public JumpVal_N(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        int cArgs = Handy.readMagnitude(in);
        int[] anArg = new int[cArgs];
        this.m_afIsSwitch = Handy.readPackedLong(in);
        for (int i = 0; i < cArgs; ++i) {
            anArg[i] = Handy.readPackedInt(in);
        }
        this.m_anArgCond = anArg;
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_aArgCond != null) {
            this.m_anArgCond = JumpVal_N.encodeArguments(this.m_aArgCond, registry);
        }
        int[] anArg = this.m_anArgCond;
        int cArgs = anArg.length;
        Handy.writePackedLong(out, cArgs);
        Handy.writePackedLong(out, this.m_afIsSwitch);
        for (int i = 0; i < cArgs; ++i) {
            Handy.writePackedLong(out, anArg[i]);
        }
    }

    @Override
    public int getOpCode() {
        return 143;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle[] ahValue = frame.getArguments(this.m_anArgCond, this.m_anArgCond.length);
            if (JumpVal_N.anyDeferred(ahValue)) {
                Frame.Continuation stepNext = frameCaller -> this.ensureJumpMap(frame, iPC, ahValue);
                return new Utils.GetArguments(ahValue, stepNext).doNext(frame);
            }
            return this.ensureJumpMap(frame, iPC, ahValue);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int ensureJumpMap(Frame frame, int iPC, ObjectHandle[] ahValue) {
        return this.m_algorithm == null ? this.explodeConstants(frame, iPC, ahValue, 0, new ObjectHandle[this.m_aofCase.length][]) : this.complete(frame, iPC, ahValue);
    }

    protected int explodeConstants(Frame frame, int iPC, ObjectHandle[] ahValue, int iRow, ObjectHandle[][] aahCases) {
        ConstHeap heap = frame.f_context.f_container.f_heap;
        ConstantPool poolTarget = frame.f_function.getConstantPool();
        int cRows = this.m_aofCase.length;
        while (iRow < cRows) {
            int cColumns = ahValue.length;
            ArrayConstant contValues = (ArrayConstant)frame.getConstant(this.m_anConstCase[iRow]);
            Constant[] aconstValues = contValues.getValue();
            ObjectHandle[] ahCases = new ObjectHandle[cColumns];
            aahCases[iRow] = ahCases;
            assert (aconstValues.length == cColumns);
            boolean fDeferred = false;
            for (int iC = 0; iC < cColumns; ++iC) {
                Constant constCase = aconstValues[iC];
                if (constCase instanceof MatchAnyConstant) {
                    ahCases[iC] = ObjectHandle.DEFAULT;
                    continue;
                }
                ahCases[iC] = frame.getConstHandle(constCase);
                ObjectHandle hCase = ahCases[iC];
                if (JumpVal_N.isDeferred(hCase)) {
                    fDeferred = true;
                    continue;
                }
                if (hCase.getComposition().getConstantPool() == poolTarget) continue;
                hCase = heap.relocateConst(hCase, constCase);
                assert (hCase != null);
                ahCases[iC] = hCase;
            }
            if (fDeferred) {
                int iRowNext = iRow + 1;
                Frame.Continuation stepNext = frameCaller -> this.explodeConstants(frame, iPC, ahValue, iRowNext, aahCases);
                return new Utils.GetArguments(ahCases, stepNext).doNext(frame);
            }
            ++iRow;
        }
        this.m_aahCases = aahCases;
        if (this.m_aofCase.length < 64) {
            this.buildSmallJumpMaps(frame);
        } else {
            this.buildLargeJumpMaps(frame);
        }
        return this.complete(frame, iPC, ahValue);
    }

    protected int complete(Frame frame, int iPC, ObjectHandle[] ahValue) {
        return this.m_aofCase.length < 64 ? this.findSmall(frame, iPC, ahValue) : this.findLarge(frame, iPC, ahValue);
    }

    protected int findSmall(Frame frame, int iPC, ObjectHandle[] ahValue) {
        OpSwitch.Algorithm[] aAlg = this.m_aAlgorithm;
        Map<ObjectHandle, Long>[] aMap = this.m_amapJumpSmall;
        long[] alWild = this.m_alWildcardSmall;
        long afIs = this.m_afIsSwitch;
        long ixBits = -1L;
        int cCols = ahValue.length;
        block4: for (int iCol = 0; iCol < cCols; ++iCol) {
            ObjectHandle hValue = ahValue[iCol];
            long ixColumn = 0L;
            switch (aAlg[iCol]) {
                case NativeRange: {
                    List<Object[]> listRange = this.m_alistRangeSmall[iCol];
                    int cR = listRange.size();
                    for (int iRange = 0; iRange < cR; ++iRange) {
                        Object[] ao = listRange.get(iRange);
                        long lBit = (Long)ao[2];
                        if ((lBit & ixBits) == 0L) continue;
                        ObjectHandle hLow = (ObjectHandle)ao[0];
                        ObjectHandle hHigh = (ObjectHandle)ao[1];
                        if (!hValue.isNativeEqual() || hValue.compareTo(hLow) < 0 || hValue.compareTo(hHigh) > 0) continue;
                        ixColumn |= lBit;
                    }
                }
                case NativeSimple: {
                    if ((afIs & 1L << iCol) == 0L) {
                        Long LBits = aMap[iCol].get(hValue);
                        if (LBits == null) break;
                        ixColumn |= LBits.longValue();
                        break;
                    }
                    TypeConstant typeVal = hValue.getType();
                    ObjectHandle[][] aahCases = this.m_aahCases;
                    int cRows = aahCases.length;
                    for (int iRow = 0; iRow < cRows; ++iRow) {
                        xRTType.TypeHandle hCase = (xRTType.TypeHandle)aahCases[iRow][iCol];
                        if (!typeVal.isA(hCase.getDataType())) continue;
                        ixColumn |= 1L << iRow;
                    }
                    break;
                }
                default: {
                    continue block4;
                }
            }
            ixBits &= (ixColumn |= alWild[iCol]);
        }
        if (ixBits == 0L) {
            return iPC + this.m_ofDefault;
        }
        if (this.m_algorithm.isNative()) {
            long lCaseBit = Long.lowestOneBit(ixBits);
            return iPC + this.m_aofCase[Long.numberOfTrailingZeros(lCaseBit)];
        }
        return this.findSmallNatural(frame, iPC, ahValue, ixBits, 0, 0);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected int findSmallNatural(Frame frame, int iPC, ObjectHandle[] ahValue, long ixBits, int iRow, int iCol) {
        ObjectHandle[][] aahCases = this.m_aahCases;
        OpSwitch.Algorithm[] aAlg = this.m_aAlgorithm;
        int cRows = aahCases.length;
        int cColumns = ahValue.length;
        while (iRow < cRows) {
            long lCaseBit = 1L << iRow;
            if ((ixBits & lCaseBit) != 0L) {
                ObjectHandle[] ahCases = aahCases[iRow];
                int iCurrentRow = iRow;
                block15: while (true) {
                    if (iCol >= cColumns) {
                        return iPC + this.m_aofCase[Long.numberOfTrailingZeros(lCaseBit)];
                    }
                    ObjectHandle hCase = ahCases[iCol];
                    if (hCase != ObjectHandle.DEFAULT) {
                        TypeConstant typeColumn = this.m_atypeColumn[iCol];
                        ObjectHandle hValue = ahValue[iCol];
                        int iCurrentCol = iCol;
                        block0 : switch (aAlg[iCol]) {
                            case NaturalRange: {
                                if (hCase.getType().isA(frame.poolContext().typeRange())) {
                                    ObjectHandle.GenericHandle hRange = (ObjectHandle.GenericHandle)hCase;
                                    ObjectHandle hLo = hRange.getField(null, "lowerBound");
                                    ObjectHandle hHi = hRange.getField(null, "upperBound");
                                    xBoolean.BooleanHandle hLoEx = (xBoolean.BooleanHandle)hRange.getField(null, "lowerExclusive");
                                    xBoolean.BooleanHandle hHiEx = (xBoolean.BooleanHandle)hRange.getField(null, "upperExclusive");
                                    Frame.Continuation stepNext = frameCaller -> this.findSmallNatural(frameCaller, iPC, ahValue, ixBits, iCurrentRow, iCurrentCol + 1);
                                    switch (this.checkRange(frame, typeColumn, hValue, hLo, hHi, hLoEx.get(), hHiEx.get(), true, stepNext)) {
                                        case -1: {
                                            if (frame.popStack() != xBoolean.TRUE) break block15;
                                            break block0;
                                        }
                                        case -5: {
                                            frame.m_frameNext.addContinuation(frameCaller -> frameCaller.popStack() == xBoolean.TRUE ? this.findSmallNatural(frameCaller, iPC, ahValue, ixBits, iCurrentRow, iCurrentCol + 1) : this.findSmallNatural(frameCaller, iPC, ahValue, ixBits, iCurrentRow + 1, 0));
                                            return -5;
                                        }
                                        case -3: {
                                            return -3;
                                        }
                                        default: {
                                            throw new IllegalStateException();
                                        }
                                    }
                                }
                            }
                            case NaturalSimple: {
                                switch (typeColumn.callEquals(frame, hValue, hCase, -1)) {
                                    case -1: {
                                        if (frame.popStack() != xBoolean.TRUE) break block15;
                                        break block0;
                                    }
                                    case -5: {
                                        frame.m_frameNext.addContinuation(frameCaller -> frameCaller.popStack() == xBoolean.TRUE ? this.findSmallNatural(frameCaller, iPC, ahValue, ixBits, iCurrentRow, iCurrentCol + 1) : this.findSmallNatural(frameCaller, iPC, ahValue, ixBits, iCurrentRow + 1, 0));
                                        return -5;
                                    }
                                    case -3: {
                                        return -3;
                                    }
                                    default: {
                                        throw new IllegalStateException();
                                    }
                                }
                            }
                        }
                    }
                    ++iCol;
                }
            }
            ++iRow;
        }
        return iPC + this.m_ofDefault;
    }

    protected int findLarge(Frame frame, int iPC, ObjectHandle[] ahValue) {
        throw new UnsupportedOperationException();
    }

    private synchronized void buildSmallJumpMaps(Frame frame) {
        if (this.m_algorithm != null) {
            return;
        }
        ObjectHandle[][] aahCases = this.m_aahCases;
        int[] anConstCase = this.m_anConstCase;
        int[] anArg = this.m_anArgCond;
        long afIs = this.m_afIsSwitch;
        int cRows = anConstCase.length;
        int cColumns = anArg.length;
        Map[] amapJump = new Map[cColumns];
        long[] alWild = new long[cColumns];
        OpSwitch.Algorithm[] aAlgorithm = new OpSwitch.Algorithm[cColumns];
        OpSwitch.Algorithm algorithm = OpSwitch.Algorithm.NativeSimple;
        TypeConstant[] atypeColumn = new TypeConstant[cColumns];
        Arrays.fill((Object[])aAlgorithm, (Object)OpSwitch.Algorithm.NativeSimple);
        for (int iC = 0; iC < cColumns; ++iC) {
            if ((afIs & 1L << iC) == 0L) {
                amapJump[iC] = new HashMap(cRows);
            }
            atypeColumn[iC] = frame.getLocalType(anArg[iC], null);
        }
        TypeConstant typeRange = frame.poolContext().typeRange();
        for (int iR = 0; iR < cRows; ++iR) {
            long lCaseBit = 1L << iR;
            ObjectHandle[] ahCases = aahCases[iR];
            for (int iC = 0; iC < cColumns; ++iC) {
                boolean fRange;
                ObjectHandle hCase = ahCases[iC];
                if (hCase == ObjectHandle.DEFAULT) {
                    int n = iC;
                    alWild[n] = alWild[n] | lCaseBit;
                    continue;
                }
                assert (!hCase.isMutable());
                TypeConstant typeCase = hCase.getType();
                TypeConstant typeColumn = atypeColumn[iC];
                boolean bl = fRange = typeCase.isA(typeRange) && !typeColumn.isA(typeRange);
                if (aAlgorithm[iC].isNative()) {
                    if (hCase.isNativeEqual()) {
                        Map mapJump = amapJump[iC];
                        if (mapJump != null) {
                            mapJump.compute(hCase, (h, LOld) -> lCaseBit | (LOld == null ? 0L : LOld));
                        }
                    } else {
                        aAlgorithm[iC] = fRange ? (this.addRange((ObjectHandle.GenericHandle)hCase, lCaseBit, cColumns, iC) ? aAlgorithm[iC].worstOf(OpSwitch.Algorithm.NativeRange) : OpSwitch.Algorithm.NaturalRange) : OpSwitch.Algorithm.NaturalSimple;
                    }
                } else if (fRange) {
                    aAlgorithm[iC] = OpSwitch.Algorithm.NaturalRange;
                    this.addRange((ObjectHandle.GenericHandle)hCase, lCaseBit, cColumns, iC);
                } else {
                    amapJump[iC].compute(hCase, (h, LOld) -> lCaseBit | (LOld == null ? 0L : LOld));
                }
                algorithm = algorithm.worstOf(aAlgorithm[iC]);
            }
        }
        this.m_atypeColumn = atypeColumn;
        this.m_amapJumpSmall = amapJump;
        this.m_alWildcardSmall = alWild;
        this.m_aAlgorithm = aAlgorithm;
        this.m_algorithm = algorithm;
    }

    private boolean addRange(ObjectHandle.GenericHandle hRange, long lCaseBit, int cColumns, int iC) {
        ObjectHandle hLow = hRange.getField(null, "lowerBound");
        ObjectHandle hHigh = hRange.getField(null, "upperBound");
        this.ensureRangeList(cColumns, iC).add(new Object[]{hLow, hHigh, lCaseBit});
        return hLow.isNativeEqual();
    }

    private List<Object[]> ensureRangeList(int cColumns, int iCol) {
        List<Object[]> list;
        List<Object[]>[] alist = this.m_alistRangeSmall;
        if (alist == null) {
            alist = this.m_alistRangeSmall = new List[cColumns];
        }
        if ((list = alist[iCol]) == null) {
            list = alist[iCol] = new ArrayList<Object[]>();
        }
        return list;
    }

    private synchronized void buildLargeJumpMaps(Frame frame) {
        assert (frame != null);
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        JumpVal_N.registerArguments(this.m_aArgCond, registry);
        super.registerConstants(registry);
    }

    @Override
    protected void appendArgDescription(StringBuilder sb) {
        int cArgConds = this.m_aArgCond == null ? 0 : this.m_aArgCond.length;
        int cNArgConds = this.m_anArgCond == null ? 0 : this.m_anArgCond.length;
        int cArgs = Math.max(cArgConds, cNArgConds);
        for (int i = 0; i < cArgs; ++i) {
            Argument arg = i < cArgConds ? this.m_aArgCond[i] : null;
            int nArg = i < cNArgConds ? this.m_anArgCond[i] : 1000000000;
            sb.append(Argument.toIdString(arg, nArg)).append(", ");
        }
    }
}

