/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpProperty;
import org.xvm.asm.Scope;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;

public class L_Get
extends OpProperty {
    private int m_nRetValue;
    private Argument m_argReturn;

    public L_Get(PropertyConstant idProp, Argument argReturn) {
        super(idProp);
        this.m_argReturn = argReturn;
    }

    public L_Get(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argReturn != null) {
            this.m_nRetValue = L_Get.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 165;
    }

    @Override
    public int process(Frame frame, int iPC) {
        ObjectHandle hTarget = frame.getThis();
        PropertyConstant constProperty = (PropertyConstant)frame.getConstant(this.m_nPropId);
        if (frame.isNextRegister(this.m_nRetValue)) {
            frame.introducePropertyVar(this.m_nRetValue, -5, this.m_nPropId);
        }
        return hTarget.getTemplate().getPropertyValue(frame, hTarget, constProperty, this.m_nRetValue);
    }

    @Override
    public void resetSimulation() {
        L_Get.resetRegister(this.m_argReturn);
    }

    @Override
    public void simulate(Scope scope) {
        L_Get.checkNextRegister(scope, this.m_argReturn, this.m_nRetValue);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argReturn = L_Get.registerArgument(this.m_argReturn, registry);
    }

    @Override
    public String toString() {
        return super.toString() + ", " + Argument.toIdString(this.m_argReturn, this.m_nRetValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        bctx.buildGetProperty(code, bctx.loadThis(code), this.m_nPropId, this.m_nRetValue);
    }
}

