/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpProperty;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;

public class L_Set
extends OpProperty {
    private int m_nValue;
    private Argument m_argValue;

    public L_Set(PropertyConstant idProp, Argument argValue) {
        super(idProp);
        this.m_argValue = argValue;
    }

    public L_Set(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argValue != null) {
            this.m_nValue = L_Set.encodeArgument(this.m_argValue, registry);
        }
        Handy.writePackedLong(out, this.m_nValue);
    }

    @Override
    public int getOpCode() {
        return 166;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hValue = frame.getArgument(this.m_nValue);
            ObjectHandle hTarget = frame.getThis();
            PropertyConstant idProp = (PropertyConstant)frame.getConstant(this.m_nPropId);
            return L_Set.isDeferred(hValue) ? hValue.proceed(frame, frameCaller -> hTarget.getTemplate().setPropertyValue(frameCaller, hTarget, idProp, frameCaller.popStack())) : hTarget.getTemplate().setPropertyValue(frame, hTarget, idProp, hValue);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argValue = L_Set.registerArgument(this.m_argValue, registry);
    }

    @Override
    public String toString() {
        return super.toString() + ", " + Argument.toIdString(this.m_argValue, this.m_nValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        bctx.buildSetProperty(code, bctx.loadThis(code), this.m_nPropId, this.m_nValue);
    }
}

