/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.lang.classfile.CodeBuilder;
import java.util.List;
import org.xvm.asm.Op;
import org.xvm.asm.OpJump;
import org.xvm.asm.op.Exit;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.Frame;

public class LoopEnd
extends Exit {
    protected int m_ofJmp;
    private Op m_opDest;

    @Override
    public int getOpCode() {
        return 120;
    }

    @Override
    public void resolveAddresses(Op[] aop) {
        if (this.m_opDest == null) {
            int depth = 1;
            for (int ip = this.getAddress() - 1; ip >= 0; --ip) {
                Op op = aop[ip];
                int code = op.getOpCode();
                if (code == 119) {
                    if (--depth != 0) continue;
                    this.m_opDest = op;
                    break;
                }
                if (code != 120) continue;
                ++depth;
            }
            assert (this.m_opDest != null);
        }
        this.m_ofJmp = this.calcRelativeAddress(this.m_opDest);
        assert (this.m_ofJmp < 0);
    }

    @Override
    public void markReachable(Op[] aop) {
        super.markReachable(aop);
        assert (this.m_ofJmp < 0);
        this.m_opDest = aop[this.getAddress() + this.m_ofJmp];
        assert (this.m_opDest.getOpCode() == 119);
    }

    @Override
    public boolean branches(Op[] aop, List<Integer> list) {
        list.add(this.m_ofJmp);
        return true;
    }

    @Override
    public boolean advances() {
        return false;
    }

    @Override
    public int process(Frame frame, int iPC) {
        frame.exitScope();
        return LoopEnd.jump(frame, iPC + this.m_ofJmp, 0);
    }

    @Override
    public String toString() {
        return LoopEnd.toName(this.getOpCode()) + " " + OpJump.getLabelDesc(this.m_opDest, this.m_ofJmp);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        code.goto_(bctx.ensureLabel(code, this.getAddress() + this.m_ofJmp));
        super.build(bctx, code);
    }
}

