/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpInvocable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;

public class MBind
extends OpInvocable {
    public MBind(Argument argTarget, MethodConstant constMethod, Argument argReturn) {
        super(argTarget, constMethod);
        this.m_argReturn = argReturn;
    }

    public MBind(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argReturn != null) {
            this.m_nRetValue = MBind.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 48;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hTarget = frame.getArgument(this.m_nTarget);
            return MBind.isDeferred(hTarget) ? hTarget.proceed(frame, (Frame frameCaller) -> this.proceed(frameCaller, frameCaller.popStack())) : this.proceed(frame, hTarget);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int proceed(Frame frame, ObjectHandle hTarget) {
        if (frame.isNextRegister(this.m_nRetValue)) {
            frame.introduceResolvedVar(this.m_nRetValue, frame.poolContext().typeFunction());
        }
        return this.getCallChain(frame, hTarget).bindTarget(frame, hTarget, this.m_nRetValue);
    }
}

