/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpMove;
import org.xvm.asm.Register;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;

public class Move
extends OpMove {
    public Move(Argument argFrom, Argument argTo) {
        super(argFrom, argTo);
    }

    public Move(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
    }

    @Override
    public int getOpCode() {
        return 96;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            int nFrom = this.m_nFromValue;
            int nTo = this.m_nToValue;
            ObjectHandle hValue = frame.getArgument(nFrom);
            if (frame.isNextRegister(nTo)) {
                frame.introduceVarCopy(nTo, nFrom);
            }
            return frame.assignDeferredValue(nTo, hValue);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    @Override
    public boolean checkRedundant(Op[] aop) {
        if (this.m_argFrom instanceof Register && this.m_argFrom.equals(this.m_argTo)) {
            this.markRedundant();
            return true;
        }
        return false;
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        BuildContext.Slot slotFrom = bctx.loadArgument(code, this.m_nFromValue);
        BuildContext.Slot slotTo = bctx.ensureSlot(this.m_nToValue, slotFrom.type(), slotFrom.cd(), "");
        bctx.storeValue(code, slotTo);
    }
}

