/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpMove;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template.xException;
import org.xvm.util.Handy;

public class MoveCast
extends OpMove {
    protected int m_nToType;
    private TypeConstant m_typeTo;

    public MoveCast(Argument argFrom, Argument argTo, TypeConstant typeTo) {
        super(argFrom, argTo);
        this.m_typeTo = typeTo;
    }

    public MoveCast(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nToType = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_typeTo != null) {
            this.m_nToType = MoveCast.encodeArgument(this.m_typeTo, registry);
        }
        Handy.writePackedLong(out, this.m_nToType);
    }

    @Override
    public int getOpCode() {
        return 102;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hValue = frame.getArgument(this.m_nFromValue);
            return MoveCast.isDeferred(hValue) ? hValue.proceed(frame, frameCaller -> this.complete(frameCaller, frameCaller.popStack())) : this.complete(frame, hValue);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, ObjectHandle hValue) {
        TypeConstant typeTo;
        TypeConstant typeFrom = hValue.getUnsafeType();
        if (!typeFrom.isA(typeTo = frame.resolveType(this.m_nToType))) {
            return frame.raiseException(xException.typeMismatch(frame, typeFrom.getValueString()));
        }
        if (frame.isNextRegister(this.m_nToValue)) {
            frame.introduceResolvedVar(this.m_nToValue, typeTo);
        }
        return frame.assignValue(this.m_nToValue, hValue);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_typeTo = (TypeConstant)MoveCast.registerArgument(this.m_typeTo, registry);
    }

    @Override
    public String toString() {
        return super.toString() + ", " + Argument.toIdString(this.m_typeTo, this.m_nToType);
    }
}

