/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.OpMove;
import org.xvm.asm.Register;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.reflect.xRef;

public class MoveRef
extends OpMove {
    public MoveRef(Register regSrc, Argument argDest) {
        super(regSrc, argDest);
    }

    public MoveRef(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
    }

    @Override
    public int getOpCode() {
        return 98;
    }

    @Override
    public int process(Frame frame, int iPC) {
        xRef.RefHandle hRef;
        boolean fNextReg = frame.isNextRegister(this.m_nToValue);
        TypeConstant typeReg = null;
        if (this.m_nFromValue >= 0) {
            Frame.VarInfo infoSrc = frame.getVarInfo(this.m_nFromValue);
            if (infoSrc.isDynamicVar()) {
                hRef = (xRef.RefHandle)frame.f_ahVar[this.m_nFromValue];
                if (fNextReg) {
                    typeReg = infoSrc.getType();
                }
            } else {
                TypeComposition clzRef = xRef.INSTANCE.ensureParameterizedClass(frame.f_context.f_container, infoSrc.getType());
                hRef = new xRef.RefHandle(clzRef, frame, this.m_nFromValue);
                typeReg = hRef.getType();
            }
        } else {
            switch (this.m_nFromValue) {
                case -13: 
                case -12: 
                case -11: 
                case -10: 
                case -9: 
                case -8: 
                case -7: 
                case -6: 
                case -5: 
                case -1: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            ObjectHandle hReferent = frame.getPredefinedArgument(this.m_nFromValue);
            ConstantPool pool = frame.poolContext();
            typeReg = pool.ensureParameterizedTypeConstant(pool.typeRef(), hReferent.getType());
            hRef = new xRef.RefHandle(typeReg.ensureClass(frame), null, hReferent);
        }
        if (fNextReg) {
            frame.introduceResolvedVar(this.m_nToValue, typeReg);
        }
        frame.assignValue(this.m_nToValue, hRef);
        return iPC + 1;
    }
}

