/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.OpMove;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;

public class MoveType
extends OpMove {
    public MoveType(Argument argSrc, Argument argDest) {
        super(argSrc, argDest);
    }

    public MoveType(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
    }

    @Override
    public int getOpCode() {
        return 101;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hValue = frame.getArgument(this.m_nFromValue);
            return MoveType.isDeferred(hValue) ? hValue.proceed(frame, frameCaller -> this.complete(frameCaller, frameCaller.popStack())) : this.complete(frame, hValue);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, ObjectHandle hValue) {
        ConstantPool pool = frame.poolContext();
        int nTo = this.m_nToValue;
        TypeConstant type = hValue.getComposition().getType();
        if (frame.isNextRegister(nTo)) {
            frame.introduceResolvedVar(nTo, pool.ensureParameterizedTypeConstant(pool.typeType(), type));
        }
        return frame.assignValue(nTo, type.ensureTypeHandle(frame.f_context.f_container));
    }
}

