/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.OpMove;
import org.xvm.asm.Register;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.runtime.template.reflect.xVar;

public class MoveVar
extends OpMove {
    public MoveVar(Register regSrc, Argument argDest) {
        super(regSrc, argDest);
    }

    public MoveVar(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
    }

    @Override
    public int getOpCode() {
        return 97;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            int nFrom = this.m_nFromValue;
            if (frame.isDynamicVar(nFrom)) {
                int nTo = this.m_nToValue;
                xRef.RefHandle hRef = (xRef.RefHandle)frame.f_ahVar[nFrom];
                if (frame.isNextRegister(nTo)) {
                    frame.introduceResolvedVar(nTo, hRef.getType());
                }
                return frame.assignValue(nTo, hRef);
            }
            ObjectHandle hReferent = null;
            if (frame.isAssigned(nFrom) && MoveVar.isDeferred(hReferent = frame.getArgument(nFrom))) {
                return hReferent.proceed(frame, frameCaller -> this.complete(frameCaller, frameCaller.popStack()));
            }
            return this.complete(frame, hReferent);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, ObjectHandle hReferent) {
        xRef.RefHandle hRef;
        int nFrom = this.m_nFromValue;
        int nTo = this.m_nToValue;
        boolean fNextReg = frame.isNextRegister(nTo);
        if (fNextReg || nTo == -1) {
            TypeConstant typeReferent;
            TypeConstant typeConstant = typeReferent = hReferent == null ? null : hReferent.getType();
            if (typeReferent == null || !typeReferent.isShared(frame.poolContext())) {
                typeReferent = nFrom == -1 ? frame.poolContext().typeObject() : frame.getVarInfo(nFrom).getType();
            }
            TypeComposition clzRef = xVar.INSTANCE.ensureParameterizedClass(frame.f_context.f_container, typeReferent);
            hRef = new xRef.RefHandle(clzRef, frame, nFrom);
            if (fNextReg) {
                frame.introduceResolvedVar(nTo, hRef.getType());
            }
        } else {
            TypeComposition clzRef = frame.getVarInfo(nTo).getType().ensureClass(frame);
            hRef = new xRef.RefHandle(clzRef, frame, nFrom);
        }
        return frame.assignValue(nTo, hRef);
    }
}

