/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;

public class NewCG_0
extends OpCallable {
    private int m_nParentValue;
    private int m_nTypeValue;
    private Argument m_argParent;
    private Argument m_argType;

    public NewCG_0(MethodConstant constMethod, Argument argParent, Argument argType, Argument argReturn) {
        super(constMethod);
        this.m_argParent = argParent;
        this.m_argType = argType;
        this.m_argReturn = argReturn;
    }

    public NewCG_0(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nParentValue = Handy.readPackedInt(in);
        this.m_nTypeValue = Handy.readPackedInt(in);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argParent != null) {
            this.m_nParentValue = NewCG_0.encodeArgument(this.m_argParent, registry);
            this.m_nTypeValue = NewCG_0.encodeArgument(this.m_argType, registry);
            this.m_nRetValue = NewCG_0.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nParentValue);
        Handy.writePackedLong(out, this.m_nTypeValue);
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 68;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hParent = frame.getArgument(this.m_nParentValue);
            return NewCG_0.isDeferred(hParent) ? hParent.proceed(frame, frameCaller -> this.complete(frameCaller, frameCaller.popStack())) : this.complete(frame, hParent);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, ObjectHandle hParent) {
        MethodStructure constructor = this.getChildConstructor(frame, hParent);
        if (constructor == null) {
            return this.reportMissingConstructor(frame, hParent);
        }
        TypeConstant typeChild = frame.resolveType(this.m_nTypeValue);
        ObjectHandle[] ahVar = new ObjectHandle[constructor.getMaxVars()];
        return this.constructChild(frame, constructor, hParent, typeChild, ahVar);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argParent = NewCG_0.registerArgument(this.m_argParent, registry);
        this.m_argType = NewCG_0.registerArgument(this.m_argType, registry);
    }
}

