/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;

public class NewCG_1
extends OpCallable {
    private int m_nParentValue;
    private int m_nTypeValue;
    private int m_nArgValue;
    private Argument m_argParent;
    private Argument m_argType;
    private Argument m_argValue;

    public NewCG_1(MethodConstant constMethod, Argument argParent, Argument argType, Argument argValue, Argument argReturn) {
        super(constMethod);
        this.m_argParent = argParent;
        this.m_argValue = argValue;
        this.m_argType = argType;
        this.m_argReturn = argReturn;
    }

    public NewCG_1(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nParentValue = Handy.readPackedInt(in);
        this.m_nTypeValue = Handy.readPackedInt(in);
        this.m_nArgValue = Handy.readPackedInt(in);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argParent != null) {
            this.m_nParentValue = NewCG_1.encodeArgument(this.m_argParent, registry);
            this.m_nTypeValue = NewCG_1.encodeArgument(this.m_argType, registry);
            this.m_nArgValue = NewCG_1.encodeArgument(this.m_argValue, registry);
            this.m_nRetValue = NewCG_1.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nParentValue);
        Handy.writePackedLong(out, this.m_nTypeValue);
        Handy.writePackedLong(out, this.m_nArgValue);
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 69;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hParent = frame.getArgument(this.m_nParentValue);
            ObjectHandle hArg = frame.getArgument(this.m_nArgValue);
            return NewCG_1.isDeferred(hParent) ? hParent.proceed(frame, frameCaller -> this.collectArg(frameCaller, frameCaller.popStack(), hArg)) : this.collectArg(frame, hParent, hArg);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int collectArg(Frame frame, ObjectHandle hParent, ObjectHandle hArg) {
        MethodStructure constructor = this.getChildConstructor(frame, hParent);
        if (constructor == null) {
            return this.reportMissingConstructor(frame, hParent);
        }
        TypeConstant typeChild = frame.resolveType(this.m_nTypeValue);
        ObjectHandle[] ahVar = new ObjectHandle[constructor.getMaxVars()];
        ahVar[0] = hArg;
        return NewCG_1.isDeferred(hArg) ? hArg.proceed(frame, frameCaller -> {
            ahVar[0] = frameCaller.popStack();
            return this.constructChild(frameCaller, constructor, hParent, typeChild, ahVar);
        }) : this.constructChild(frame, constructor, hParent, typeChild, ahVar);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argParent = NewCG_1.registerArgument(this.m_argParent, registry);
        this.m_argType = NewCG_1.registerArgument(this.m_argType, registry);
        this.m_argValue = NewCG_1.registerArgument(this.m_argValue, registry);
    }

    @Override
    protected String getParamsString() {
        return Argument.toIdString(this.m_argValue, this.m_nArgValue);
    }
}

