/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.util.Handy;

public class NewCG_N
extends OpCallable {
    private int m_nParentValue;
    private int m_nTypeValue;
    private int[] m_anArgValue;
    private Argument m_argParent;
    private Argument m_argType;
    private Argument[] m_aArgValue;

    public NewCG_N(MethodConstant constMethod, Argument argParent, Argument argType, Argument[] aArgValue, Argument argReturn) {
        super(constMethod);
        this.m_argParent = argParent;
        this.m_aArgValue = aArgValue;
        this.m_argType = argType;
        this.m_argReturn = argReturn;
    }

    public NewCG_N(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nParentValue = Handy.readPackedInt(in);
        this.m_nTypeValue = Handy.readPackedInt(in);
        this.m_anArgValue = NewCG_N.readIntArray(in);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argParent != null) {
            this.m_nParentValue = NewCG_N.encodeArgument(this.m_argParent, registry);
            this.m_nTypeValue = NewCG_N.encodeArgument(this.m_argType, registry);
            this.m_anArgValue = NewCG_N.encodeArguments(this.m_aArgValue, registry);
            this.m_nRetValue = NewCG_N.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nParentValue);
        Handy.writePackedLong(out, this.m_nTypeValue);
        NewCG_N.writeIntArray(out, this.m_anArgValue);
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 70;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hParent = frame.getArgument(this.m_nParentValue);
            ObjectHandle[] ahArg = frame.getArguments(this.m_anArgValue, 0);
            return NewCG_N.isDeferred(hParent) ? hParent.proceed(frame, frameCaller -> this.collectArgs(frameCaller, frameCaller.popStack(), ahArg)) : this.collectArgs(frame, hParent, ahArg);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int collectArgs(Frame frame, ObjectHandle hParent, ObjectHandle[] ahArg) {
        MethodStructure constructor = this.getChildConstructor(frame, hParent);
        if (constructor == null) {
            return this.reportMissingConstructor(frame, hParent);
        }
        TypeConstant typeChild = frame.resolveType(this.m_nTypeValue);
        ObjectHandle[] ahVar = Utils.ensureSize(ahArg, constructor.getMaxVars());
        if (NewCG_N.anyDeferred(ahVar)) {
            Frame.Continuation stepNext = frameCaller -> this.constructChild(frameCaller, constructor, hParent, typeChild, ahVar);
            return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
        }
        return this.constructChild(frame, constructor, hParent, typeChild, ahVar);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argParent = NewCG_N.registerArgument(this.m_argParent, registry);
        this.m_argType = NewCG_N.registerArgument(this.m_argType, registry);
        NewCG_N.registerArguments(this.m_aArgValue, registry);
    }

    @Override
    protected String getParamsString() {
        return NewCG_N.getParamsString(this.m_anArgValue, this.m_aArgValue);
    }
}

