/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;

public class NewC_0
extends OpCallable {
    private int m_nParentValue;
    private Argument m_argParent;

    public NewC_0(MethodConstant constMethod, Argument argParent, Argument argReturn) {
        super(constMethod);
        this.m_argParent = argParent;
        this.m_argReturn = argReturn;
    }

    public NewC_0(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nParentValue = Handy.readPackedInt(in);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argParent != null) {
            this.m_nParentValue = NewC_0.encodeArgument(this.m_argParent, registry);
            this.m_nRetValue = NewC_0.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nParentValue);
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 64;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hParent = frame.getArgument(this.m_nParentValue);
            MethodStructure constructor = this.getChildConstructor(frame, hParent);
            if (constructor == null) {
                return this.reportMissingConstructor(frame, hParent);
            }
            ObjectHandle[] ahVar = new ObjectHandle[constructor.getMaxVars()];
            return NewC_0.isDeferred(hParent) ? hParent.proceed(frame, frameCaller -> this.constructChild(frameCaller, constructor, frameCaller.popStack(), ahVar)) : this.constructChild(frame, constructor, hParent, ahVar);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argParent = NewC_0.registerArgument(this.m_argParent, registry);
    }
}

