/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.util.Handy;

public class NewC_N
extends OpCallable {
    private int m_nParentValue;
    private int[] m_anArgValue;
    private Argument m_argParent;
    private Argument[] m_aArgValue;

    public NewC_N(MethodConstant constMethod, Argument argParent, Argument[] aArgValue, Argument argReturn) {
        super(constMethod);
        this.m_argParent = argParent;
        this.m_aArgValue = aArgValue;
        this.m_argReturn = argReturn;
    }

    public NewC_N(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nParentValue = Handy.readPackedInt(in);
        this.m_anArgValue = NewC_N.readIntArray(in);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argParent != null) {
            this.m_nParentValue = NewC_N.encodeArgument(this.m_argParent, registry);
            this.m_anArgValue = NewC_N.encodeArguments(this.m_aArgValue, registry);
            this.m_nRetValue = NewC_N.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nParentValue);
        NewC_N.writeIntArray(out, this.m_anArgValue);
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 66;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hParent = frame.getArgument(this.m_nParentValue);
            MethodStructure constructor = this.getChildConstructor(frame, hParent);
            if (constructor == null) {
                return this.reportMissingConstructor(frame, hParent);
            }
            ObjectHandle[] ahVar = frame.getArguments(this.m_anArgValue, constructor.getMaxVars());
            return NewC_N.isDeferred(hParent) ? hParent.proceed(frame, frameCaller -> this.collectArgs(frameCaller, constructor, frameCaller.popStack(), ahVar)) : this.collectArgs(frame, constructor, hParent, ahVar);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int collectArgs(Frame frame, MethodStructure constructor, ObjectHandle hParent, ObjectHandle[] ahVar) {
        if (NewC_N.anyDeferred(ahVar)) {
            Frame.Continuation stepNext = frameCaller -> this.constructChild(frameCaller, constructor, hParent, ahVar);
            return new Utils.GetArguments(ahVar, stepNext).doNext(frame);
        }
        return this.constructChild(frame, constructor, hParent, ahVar);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argParent = NewC_N.registerArgument(this.m_argParent, registry);
        NewC_N.registerArguments(this.m_aArgValue, registry);
    }

    @Override
    protected String getParamsString() {
        return NewC_N.getParamsString(this.m_anArgValue, this.m_aArgValue);
    }
}

