/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.util.Handy;

public class NewG_0
extends OpCallable {
    private int m_nTypeValue;
    private Argument m_argType;

    public NewG_0(MethodConstant constMethod, Argument argType, Argument argReturn) {
        super(constMethod);
        this.m_argType = argType;
        this.m_argReturn = argReturn;
    }

    public NewG_0(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nTypeValue = Handy.readPackedInt(in);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argType != null) {
            this.m_nTypeValue = NewG_0.encodeArgument(this.m_argType, registry);
            this.m_nRetValue = NewG_0.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nTypeValue);
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 60;
    }

    @Override
    public int process(Frame frame, int iPC) {
        ObjectHandle hParent;
        MethodStructure constructor = this.getMethodStructure(frame);
        if (constructor == null) {
            return -3;
        }
        TypeComposition clzTarget = frame.resolveClass(this.m_nTypeValue);
        ObjectHandle objectHandle = hParent = clzTarget.isInstanceChild() ? frame.getThis() : null;
        if (frame.isNextRegister(this.m_nRetValue)) {
            frame.introduceResolvedVar(this.m_nRetValue, clzTarget.getType());
        }
        ObjectHandle[] ahVar = new ObjectHandle[constructor.getMaxVars()];
        return clzTarget.getTemplate().construct(frame, constructor, clzTarget, hParent, ahVar, this.m_nRetValue);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argType = NewG_0.registerArgument(this.m_argType, registry);
    }
}

