/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.util.Handy;

public class NewG_1
extends OpCallable {
    private int m_nTypeValue;
    private int m_nArgValue;
    private Argument m_argType;
    private Argument m_argValue;

    public NewG_1(MethodConstant constMethod, Argument argType, Argument argValue, Argument argReturn) {
        super(constMethod);
        this.m_argType = argType;
        this.m_argValue = argValue;
        this.m_argReturn = argReturn;
    }

    public NewG_1(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nTypeValue = Handy.readPackedInt(in);
        this.m_nArgValue = Handy.readPackedInt(in);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argType != null) {
            this.m_nTypeValue = NewG_1.encodeArgument(this.m_argType, registry);
            this.m_nArgValue = NewG_1.encodeArgument(this.m_argValue, registry);
            this.m_nRetValue = NewG_1.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nTypeValue);
        Handy.writePackedLong(out, this.m_nArgValue);
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 61;
    }

    @Override
    public int process(Frame frame, int iPC) {
        MethodStructure constructor = this.getMethodStructure(frame);
        if (constructor == null) {
            return -3;
        }
        try {
            ObjectHandle hArg = frame.getArgument(this.m_nArgValue);
            return NewG_1.isDeferred(hArg) ? hArg.proceed(frame, frameCaller -> this.complete(frameCaller, constructor, frameCaller.popStack())) : this.complete(frame, constructor, hArg);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    private int complete(Frame frame, MethodStructure constructor, ObjectHandle hArg) {
        ObjectHandle hParent;
        TypeComposition clzTarget = frame.resolveClass(this.m_nTypeValue);
        ObjectHandle objectHandle = hParent = clzTarget.isInstanceChild() ? frame.getThis() : null;
        if (frame.isNextRegister(this.m_nRetValue)) {
            frame.introduceResolvedVar(this.m_nRetValue, clzTarget.getType());
        }
        ObjectHandle[] ahVar = new ObjectHandle[constructor.getMaxVars()];
        ahVar[0] = hArg;
        return clzTarget.getTemplate().construct(frame, constructor, clzTarget, hParent, ahVar, this.m_nRetValue);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argType = NewG_1.registerArgument(this.m_argType, registry);
        this.m_argValue = NewG_1.registerArgument(this.m_argValue, registry);
    }

    @Override
    protected String getParamsString() {
        return Argument.toIdString(this.m_argType, this.m_nTypeValue) + ": " + Argument.toIdString(this.m_argValue, this.m_nArgValue);
    }
}

