/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.util.Handy;

public class NewG_N
extends OpCallable {
    private int m_nTypeValue;
    private int[] m_anArgValue;
    private Argument m_argType;
    private Argument[] m_aArgValue;

    public NewG_N(MethodConstant constMethod, Argument argType, Argument[] aArgValue, Argument argReturn) {
        super(constMethod);
        this.m_aArgValue = aArgValue;
        this.m_argType = argType;
        this.m_argReturn = argReturn;
    }

    public NewG_N(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nTypeValue = Handy.readPackedInt(in);
        this.m_anArgValue = NewG_N.readIntArray(in);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argType != null) {
            this.m_nTypeValue = NewG_N.encodeArgument(this.m_argType, registry);
            this.m_anArgValue = NewG_N.encodeArguments(this.m_aArgValue, registry);
            this.m_nRetValue = NewG_N.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nTypeValue);
        NewG_N.writeIntArray(out, this.m_anArgValue);
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 62;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            MethodStructure constructor = this.getMethodStructure(frame);
            if (constructor == null) {
                return -3;
            }
            ObjectHandle[] ahVar = frame.getArguments(this.m_anArgValue, constructor.getMaxVars());
            if (NewG_N.anyDeferred(ahVar)) {
                Frame.Continuation stepNext = frameCaller -> this.complete(frameCaller, constructor, ahVar);
                return new Utils.GetArguments(ahVar, stepNext).doNext(frame);
            }
            return this.complete(frame, constructor, ahVar);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    private int complete(Frame frame, MethodStructure constructor, ObjectHandle[] ahVar) {
        ObjectHandle hParent;
        TypeComposition clzTarget = frame.resolveClass(this.m_nTypeValue);
        ObjectHandle objectHandle = hParent = clzTarget.isInstanceChild() ? frame.getThis() : null;
        if (frame.isNextRegister(this.m_nRetValue)) {
            frame.introduceResolvedVar(this.m_nRetValue, clzTarget.getType());
        }
        return clzTarget.getTemplate().construct(frame, constructor, clzTarget, hParent, ahVar, this.m_nRetValue);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argType = NewG_N.registerArgument(this.m_argType, registry);
        NewG_N.registerArguments(this.m_aArgValue, registry);
    }

    @Override
    protected String getParamsString() {
        return Argument.toIdString(this.m_argType, this.m_nTypeValue) + ": " + NewG_N.getParamsString(this.m_anArgValue, this.m_aArgValue);
    }
}

