/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template._native.reflect.xRTType;
import org.xvm.util.Handy;

public class NewV_0
extends OpCallable {
    private int m_nType;
    private Argument m_argType;

    public NewV_0(MethodConstant constMethod, Argument argType, Argument argReturn) {
        super(constMethod);
        this.m_argType = argType;
        this.m_argReturn = argReturn;
    }

    public NewV_0(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nType = Handy.readPackedInt(in);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argType != null) {
            this.m_nType = NewV_0.encodeArgument(this.m_argType, registry);
            this.m_nRetValue = NewV_0.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nType);
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 72;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hType = frame.getArgument(this.m_nType);
            return NewV_0.isDeferred(hType) ? hType.proceed(frame, frameCaller -> this.complete(frameCaller, (xRTType.TypeHandle)frameCaller.popStack())) : this.complete(frame, (xRTType.TypeHandle)hType);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, xRTType.TypeHandle hType) {
        MethodStructure constructor = this.getTypeConstructor(frame, hType);
        if (constructor == null) {
            return this.reportMissingConstructor(frame, hType);
        }
        TypeConstant typeTarget = hType.getDataType();
        TypeComposition clzTarget = typeTarget.ensureClass(frame);
        int nReturn = this.m_nRetValue;
        if (frame.isNextRegister(nReturn)) {
            frame.introduceResolvedVar(nReturn, typeTarget);
        }
        ObjectHandle[] ahVar = new ObjectHandle[constructor.getMaxVars()];
        return clzTarget.getTemplate().construct(frame, constructor, clzTarget, null, ahVar, nReturn);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argType = NewV_0.registerArgument(this.m_argType, registry);
    }

    @Override
    protected String getParamsString() {
        return Argument.toIdString(this.m_argType, this.m_nType);
    }
}

