/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.template._native.reflect.xRTType;
import org.xvm.util.Handy;

public class NewV_1
extends OpCallable {
    private int m_nType;
    private int m_nArgValue;
    private Argument m_argType;
    private Argument m_argValue;

    public NewV_1(MethodConstant constMethod, Argument argType, Argument argValue, Argument argReturn) {
        super(constMethod);
        this.m_argType = argType;
        this.m_argValue = argValue;
        this.m_argReturn = argReturn;
    }

    public NewV_1(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nType = Handy.readPackedInt(in);
        this.m_nArgValue = Handy.readPackedInt(in);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argType != null) {
            this.m_nType = NewV_1.encodeArgument(this.m_argType, registry);
            this.m_nArgValue = NewV_1.encodeArgument(this.m_argValue, registry);
            this.m_nRetValue = NewV_1.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nType);
        Handy.writePackedLong(out, this.m_nArgValue);
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 73;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hType = frame.getArgument(this.m_nType);
            ObjectHandle hArg = frame.getArgument(this.m_nArgValue);
            return NewV_1.isDeferred(hType) ? hType.proceed(frame, frameCaller -> this.collectArg(frameCaller, (xRTType.TypeHandle)frameCaller.popStack(), hArg)) : this.collectArg(frame, (xRTType.TypeHandle)hType, hArg);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int collectArg(Frame frame, xRTType.TypeHandle hType, ObjectHandle hArg) {
        MethodStructure constructor = this.getTypeConstructor(frame, hType);
        if (constructor == null) {
            return this.reportMissingConstructor(frame, hType);
        }
        TypeConstant typeTarget = hType.getDataType();
        TypeComposition clzTarget = typeTarget.ensureClass(frame);
        int nReturn = this.m_nRetValue;
        if (frame.isNextRegister(nReturn)) {
            frame.introduceResolvedVar(nReturn, typeTarget);
        }
        ObjectHandle[] ahVar = new ObjectHandle[constructor.getMaxVars()];
        ahVar[0] = hArg;
        return NewV_1.isDeferred(hArg) ? hArg.proceed(frame, frameCaller -> {
            ahVar[0] = frameCaller.popStack();
            return clzTarget.getTemplate().construct(frameCaller, constructor, clzTarget, null, ahVar, nReturn);
        }) : clzTarget.getTemplate().construct(frame, constructor, clzTarget, null, ahVar, nReturn);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argType = NewV_1.registerArgument(this.m_argType, registry);
        this.m_argValue = NewV_1.registerArgument(this.m_argValue, registry);
    }

    @Override
    protected String getParamsString() {
        return Argument.toIdString(this.m_argType, this.m_nType) + ", " + Argument.toIdString(this.m_argValue, this.m_nArgValue);
    }
}

