/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template._native.reflect.xRTType;
import org.xvm.util.Handy;

public class NewV_N
extends OpCallable {
    private int m_nType;
    private int[] m_anArgValue;
    private Argument m_argType;
    private Argument[] m_aArgValue;

    public NewV_N(MethodConstant constMethod, Argument argType, Argument[] aargValue, Argument argReturn) {
        super(constMethod);
        this.m_argType = argType;
        this.m_aArgValue = aargValue;
        this.m_argReturn = argReturn;
    }

    public NewV_N(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nType = Handy.readPackedInt(in);
        this.m_anArgValue = NewV_N.readIntArray(in);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argType != null) {
            this.m_nType = NewV_N.encodeArgument(this.m_argType, registry);
            this.m_anArgValue = NewV_N.encodeArguments(this.m_aArgValue, registry);
            this.m_nRetValue = NewV_N.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nType);
        NewV_N.writeIntArray(out, this.m_anArgValue);
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 74;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hType = frame.getArgument(this.m_nType);
            ObjectHandle[] ahArg = frame.getArguments(this.m_anArgValue, 0);
            return NewV_N.isDeferred(hType) ? hType.proceed(frame, frameCaller -> this.collectArgs(frameCaller, (xRTType.TypeHandle)frameCaller.popStack(), ahArg)) : this.collectArgs(frame, (xRTType.TypeHandle)hType, ahArg);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int collectArgs(Frame frame, xRTType.TypeHandle hType, ObjectHandle[] ahArg) {
        ObjectHandle[] ahVar;
        MethodStructure constructor = this.getTypeConstructor(frame, hType);
        if (constructor == null) {
            return this.reportMissingConstructor(frame, hType);
        }
        TypeConstant typeTarget = hType.getDataType();
        TypeComposition clzTarget = typeTarget.ensureClass(frame);
        int nReturn = this.m_nRetValue;
        if (frame.isNextRegister(nReturn)) {
            frame.introduceResolvedVar(nReturn, typeTarget);
        }
        if (NewV_N.anyDeferred(ahVar = Utils.ensureSize(ahArg, constructor.getMaxVars()))) {
            Frame.Continuation stepNext = frameCaller -> clzTarget.getTemplate().construct(frameCaller, constructor, clzTarget, null, ahVar, nReturn);
            return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
        }
        return clzTarget.getTemplate().construct(frame, constructor, clzTarget, null, ahVar, nReturn);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argType = NewV_N.registerArgument(this.m_argType, registry);
        NewV_N.registerArguments(this.m_aArgValue, registry);
    }

    @Override
    protected String getParamsString() {
        return Argument.toIdString(this.m_argType, this.m_nType) + ", " + NewV_N.getParamsString(this.m_anArgValue, this.m_aArgValue);
    }
}

