/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;

public class New_0
extends OpCallable {
    public New_0(MethodConstant constMethod, Argument argReturn) {
        super(constMethod);
        this.m_argReturn = argReturn;
    }

    public New_0(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argReturn != null) {
            this.m_nRetValue = New_0.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 56;
    }

    @Override
    public int process(Frame frame, int iPC) {
        MethodStructure constructor = this.getMethodStructure(frame);
        if (constructor == null) {
            return -3;
        }
        ObjectHandle[] ahVar = new ObjectHandle[constructor.getMaxVars()];
        IdentityConstant constClz = constructor.getParent().getParent().getIdentityConstant();
        ClassTemplate template = frame.ensureTemplate(constClz);
        ClassComposition clzTarget = template.getCanonicalClass(frame.f_context.f_container);
        if (frame.isNextRegister(this.m_nRetValue)) {
            frame.introduceResolvedVar(this.m_nRetValue, clzTarget.getType());
        }
        return template.construct(frame, constructor, clzTarget, null, ahVar, this.m_nRetValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        this.buildNew(bctx, code, NO_ARGS);
    }
}

