/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;

public class New_1
extends OpCallable {
    private int m_nArgValue;
    private Argument m_argValue;

    public New_1(MethodConstant constMethod, Argument argValue, Argument argReturn) {
        super(constMethod);
        this.m_argValue = argValue;
        this.m_argReturn = argReturn;
    }

    public New_1(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nArgValue = Handy.readPackedInt(in);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argValue != null) {
            this.m_nArgValue = New_1.encodeArgument(this.m_argValue, registry);
            this.m_nRetValue = New_1.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nArgValue);
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 57;
    }

    @Override
    public int process(Frame frame, int iPC) {
        MethodStructure constructor = this.getMethodStructure(frame);
        if (constructor == null) {
            return -3;
        }
        try {
            ObjectHandle hArg = frame.getArgument(this.m_nArgValue);
            return New_1.isDeferred(hArg) ? hArg.proceed(frame, frameCaller -> this.complete(frameCaller, constructor, frameCaller.popStack())) : this.complete(frame, constructor, hArg);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    private int complete(Frame frame, MethodStructure constructor, ObjectHandle hArg) {
        IdentityConstant constClz = constructor.getParent().getParent().getIdentityConstant();
        ClassTemplate template = frame.ensureTemplate(constClz);
        ClassComposition clzTarget = template.getCanonicalClass(frame.f_context.f_container);
        if (frame.isNextRegister(this.m_nRetValue)) {
            frame.introduceResolvedVar(this.m_nRetValue, clzTarget.getType());
        }
        ObjectHandle[] ahVar = new ObjectHandle[constructor.getMaxVars()];
        ahVar[0] = hArg;
        return template.construct(frame, constructor, clzTarget, null, ahVar, this.m_nRetValue);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argValue = New_1.registerArgument(this.m_argValue, registry);
    }

    @Override
    protected String getParamsString() {
        return Argument.toIdString(this.m_argValue, this.m_nArgValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        this.buildNew(bctx, code, new int[]{this.m_nArgValue});
    }
}

