/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.util.Handy;

public class New_N
extends OpCallable {
    private int[] m_anArgValue;
    private Argument[] m_aArgValue;

    public New_N(MethodConstant constMethod, Argument[] aArgValue, Argument argReturn) {
        super(constMethod);
        Handy.checkElementsNonNull(aArgValue);
        this.m_aArgValue = aArgValue;
        this.m_argReturn = argReturn;
    }

    public New_N(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_anArgValue = New_N.readIntArray(in);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_aArgValue != null) {
            this.m_anArgValue = New_N.encodeArguments(this.m_aArgValue, registry);
            this.m_nRetValue = New_N.encodeArgument(this.m_argReturn, registry);
        }
        New_N.writeIntArray(out, this.m_anArgValue);
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 58;
    }

    @Override
    public int process(Frame frame, int iPC) {
        MethodStructure constructor = this.getMethodStructure(frame);
        if (constructor == null) {
            return -3;
        }
        try {
            ObjectHandle[] ahVar = frame.getArguments(this.m_anArgValue, constructor.getMaxVars());
            IdentityConstant constClz = constructor.getParent().getParent().getIdentityConstant();
            ClassTemplate template = frame.ensureTemplate(constClz);
            ClassComposition clzTarget = template.getCanonicalClass(frame.f_context.f_container);
            if (frame.isNextRegister(this.m_nRetValue)) {
                frame.introduceResolvedVar(this.m_nRetValue, clzTarget.getType());
            }
            if (New_N.anyDeferred(ahVar)) {
                Frame.Continuation stepNext = frameCaller -> template.construct(frameCaller, constructor, clzTarget, null, ahVar, this.m_nRetValue);
                return new Utils.GetArguments(ahVar, stepNext).doNext(frame);
            }
            return template.construct(frame, constructor, clzTarget, null, ahVar, this.m_nRetValue);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        New_N.registerArguments(this.m_aArgValue, registry);
    }

    @Override
    protected String getParamsString() {
        return New_N.getParamsString(this.m_anArgValue, this.m_aArgValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        this.buildNew(bctx, code, this.m_anArgValue);
    }
}

