/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.Op;
import org.xvm.asm.OpCallable;
import org.xvm.asm.constants.IdentityConstant;
import org.xvm.asm.constants.MethodConstant;
import org.xvm.runtime.ClassComposition;
import org.xvm.runtime.ClassTemplate;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.collections.xTuple;
import org.xvm.util.Handy;

public class New_T
extends OpCallable {
    private int m_nArgTupleValue;
    private Argument m_argValue;

    public New_T(MethodConstant constMethod, Argument argValue, Argument argReturn) {
        super(constMethod);
        this.m_argValue = argValue;
        this.m_argReturn = argReturn;
    }

    public New_T(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nArgTupleValue = Handy.readPackedInt(in);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argValue != null) {
            this.m_nArgTupleValue = New_T.encodeArgument(this.m_argValue, registry);
            this.m_nRetValue = New_T.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nArgTupleValue);
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 59;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hArg = frame.getArgument(this.m_nArgTupleValue);
            return New_T.isDeferred(hArg) ? hArg.proceed(frame, frameCaller -> this.complete(frameCaller, ((xTuple.TupleHandle)frameCaller.popStack()).m_ahValue)) : this.complete(frame, ((xTuple.TupleHandle)hArg).m_ahValue);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, ObjectHandle[] ahArg) {
        MethodStructure constructor = this.getMethodStructure(frame);
        if (constructor == null) {
            return -3;
        }
        IdentityConstant constClz = constructor.getParent().getParent().getIdentityConstant();
        ClassTemplate template = frame.ensureTemplate(constClz);
        ClassComposition clzTarget = template.getCanonicalClass(frame.f_context.f_container);
        if (frame.isNextRegister(this.m_nRetValue)) {
            frame.introduceResolvedVar(this.m_nRetValue, clzTarget.getType());
        }
        return template.construct(frame, constructor, clzTarget, null, Utils.ensureSize(ahArg, constructor.getMaxVars()), this.m_nRetValue);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argValue = New_T.registerArgument(this.m_argValue, registry);
    }

    @Override
    protected String getParamsString() {
        return Argument.toIdString(this.m_argValue, this.m_nArgTupleValue);
    }
}

