/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.Frame;
import org.xvm.util.Handy;

public class Nop
extends Op {
    private int m_nOp;
    private int m_cLines;

    public Nop() {
        this(0);
    }

    public Nop(int cLines) {
        this.m_nOp = Nop.nopForLines(cLines);
        this.m_cLines = cLines;
    }

    public Nop(DataInput in, Constant[] aconst) throws IOException {
        this.m_cLines = Handy.readPackedInt(in);
        this.m_nOp = Nop.nopForLines(this.m_cLines);
    }

    static int nopForLines(int cLines) {
        return switch (cLines) {
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 3;
            default -> 4;
        };
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.getOpCode() == 4) {
            Handy.writePackedLong(out, this.m_cLines);
        }
    }

    @Override
    public int getOpCode() {
        return this.m_nOp;
    }

    @Override
    public int process(Frame frame, int iPC) {
        return frame.f_context.isDebuggerActive() ? frame.f_context.getDebugger().checkBreakPoint(frame, iPC) : iPC + 1;
    }

    @Override
    public boolean isNecessary() {
        return this.m_cLines != 0;
    }

    @Override
    public boolean checkRedundant(Op[] aop) {
        int cOps = aop.length;
        for (int iOp = this.getAddress() + 1; iOp < cOps; ++iOp) {
            Op op = aop[iOp].ensureOp();
            if (op instanceof Nop) {
                Nop nop = (Nop)op;
                this.m_cLines += nop.m_cLines;
            } else {
                if (this.m_cLines == 0) break;
                return false;
            }
            this.m_nOp = Nop.nopForLines(this.m_cLines);
            nop.m_cLines = 0;
            nop.m_nOp = 0;
        }
        this.markRedundant();
        return true;
    }

    public int getLineCount() {
        return this.m_cLines;
    }

    @Override
    public String toString() {
        return this.m_nOp == 4 ? Nop.toName(this.m_nOp) + " " + this.m_cLines : Nop.toName(this.m_nOp);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        bctx.lineNumber += this.getLineCount();
        code.lineNumber(bctx.lineNumber);
    }
}

