/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpJump;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template.xBoolean;
import org.xvm.runtime.template.xOrdered;
import org.xvm.util.Handy;

public abstract class OpSwitch
extends Op {
    protected int[] m_anConstCase;
    protected int[] m_aofCase;
    protected int m_ofDefault;
    private Constant[] m_aConstCase;
    private Op[] m_aOpCase;
    private Op m_opDefault;
    protected transient int[] m_acExits;
    protected transient int m_cDefaultExits;

    protected OpSwitch(Constant[] aConstCase, Op[] aOpCase, Op opDefault) {
        assert (aOpCase != null);
        this.m_aConstCase = aConstCase;
        this.m_aOpCase = aOpCase;
        this.m_opDefault = opDefault;
    }

    protected OpSwitch(DataInput in, Constant[] aconst) throws IOException {
        int cCases = Handy.readMagnitude(in);
        int[] anArgCase = new int[cCases];
        int[] aofCase = new int[cCases];
        for (int i = 0; i < cCases; ++i) {
            anArgCase[i] = Handy.readPackedInt(in);
            aofCase[i] = Handy.readPackedInt(in);
        }
        this.m_anConstCase = anArgCase;
        this.m_aofCase = aofCase;
        this.m_ofDefault = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_aConstCase != null) {
            this.m_anConstCase = OpSwitch.encodeArguments(this.m_aConstCase, registry);
        }
        int[] anArgCase = this.m_anConstCase;
        int[] aofCase = this.m_aofCase;
        int c = anArgCase.length;
        Handy.writePackedLong(out, c);
        for (int i = 0; i < c; ++i) {
            Handy.writePackedLong(out, anArgCase[i]);
            Handy.writePackedLong(out, aofCase[i]);
        }
        Handy.writePackedLong(out, this.m_ofDefault);
    }

    @Override
    public void resolveAddresses(Op[] aop) {
        int i;
        int cCases;
        if (this.m_aOpCase == null) {
            int ofOp;
            int ofThis = this.getAddress();
            cCases = this.m_aofCase.length;
            this.m_aOpCase = new Op[cCases];
            for (int i2 = 0; i2 < cCases; ++i2) {
                int ofOp2;
                this.m_aofCase[i2] = ofOp2 = this.adjustRelativeAddress(aop, this.m_aofCase[i2]);
                this.m_aOpCase[i2] = aop[ofThis + ofOp2];
            }
            this.m_ofDefault = ofOp = this.adjustRelativeAddress(aop, this.m_ofDefault);
            this.m_opDefault = aop[ofThis + ofOp];
        } else {
            cCases = this.m_aOpCase.length;
            this.m_aofCase = new int[cCases];
            for (i = 0; i < cCases; ++i) {
                this.m_aofCase[i] = this.calcRelativeAddress(this.m_aOpCase[i]);
            }
            this.m_ofDefault = this.calcRelativeAddress(this.m_opDefault);
        }
        this.m_acExits = new int[cCases];
        for (i = 0; i < cCases; ++i) {
            this.m_acExits[i] = this.calcExits(this.m_aOpCase[i]);
        }
        this.m_cDefaultExits = this.calcExits(this.m_opDefault);
    }

    @Override
    public void markReachable(Op[] aop) {
        super.markReachable(aop);
        Op[] aOpCase = this.m_aOpCase;
        int[] aofCase = this.m_aofCase;
        int c = aofCase.length;
        for (int i = 0; i < c; ++i) {
            aOpCase[i] = this.findDestinationOp(aop, aofCase[i]);
            aofCase[i] = this.calcRelativeAddress(aOpCase[i]);
        }
        this.m_opDefault = this.findDestinationOp(aop, this.m_ofDefault);
        this.m_ofDefault = this.calcRelativeAddress(this.m_opDefault);
    }

    @Override
    public boolean branches(Op[] aop, List<Integer> list) {
        this.resolveAddresses(aop);
        for (int i : this.m_aofCase) {
            list.add(i);
        }
        list.add(this.m_ofDefault);
        return true;
    }

    @Override
    public boolean advances() {
        return false;
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        OpSwitch.registerArguments(this.m_aConstCase, registry);
    }

    protected int checkRange(Frame frame, TypeConstant typeCompare, ObjectHandle hValue, ObjectHandle hLo, ObjectHandle hHi, boolean fLoEx, boolean fHiEx, boolean fLow, Frame.Continuation continuation) {
        switch (typeCompare.callCompare(frame, hValue, fLow ? hLo : hHi, -1)) {
            case -1: {
                ObjectHandle hResult = frame.popStack();
                if (fLow) {
                    boolean fMatch;
                    boolean bl = fLoEx ? hResult == xOrdered.GREATER : (fMatch = hResult != xOrdered.LESSER);
                    if (!fMatch) {
                        frame.pushStack(xBoolean.FALSE);
                        return continuation.proceed(frame);
                    }
                    return this.checkRange(frame, typeCompare, hValue, hLo, hHi, fLoEx, fHiEx, false, continuation);
                }
                boolean fMatch = fHiEx ? hResult == xOrdered.LESSER : hResult != xOrdered.GREATER;
                frame.pushStack(xBoolean.makeHandle(fMatch));
                return continuation.proceed(frame);
            }
            case -5: {
                Frame.Continuation stepNext = frameCaller -> {
                    ObjectHandle hR = frameCaller.popStack();
                    if (fLow) {
                        boolean fMatch;
                        boolean bl = fLoEx ? hR == xOrdered.GREATER : (fMatch = hR != xOrdered.LESSER);
                        if (!fMatch) {
                            frameCaller.pushStack(xBoolean.FALSE);
                            return continuation.proceed(frameCaller);
                        }
                        return this.checkRange(frameCaller, typeCompare, hValue, hLo, hHi, fLoEx, fHiEx, false, continuation);
                    }
                    boolean fMatch = fHiEx ? hR == xOrdered.LESSER : hR != xOrdered.GREATER;
                    frameCaller.pushStack(xBoolean.makeHandle(fMatch));
                    return continuation.proceed(frameCaller);
                };
                frame.m_frameNext.addContinuation(stepNext);
                return -5;
            }
            case -3: {
                return -3;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public String toString() {
        int cNConstCases;
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(' ');
        this.appendArgDescription(sb);
        int cOps = this.m_aOpCase == null ? 0 : this.m_aOpCase.length;
        int cOffsets = this.m_aofCase == null ? 0 : this.m_aofCase.length;
        int cLabels = Math.max(cOps, cOffsets);
        sb.append(cLabels).append(":\n");
        int cConstCases = this.m_aConstCase == null ? 0 : this.m_aConstCase.length;
        int n = cNConstCases = this.m_anConstCase == null ? 0 : this.m_anConstCase.length;
        assert (Math.max(cConstCases, cNConstCases) == cLabels);
        for (int i = 0; i < cLabels; ++i) {
            int of;
            Constant arg = i < cConstCases ? this.m_aConstCase[i] : null;
            int nArg = i < cNConstCases ? this.m_anConstCase[i] : 1000000000;
            Op op = i < cOps ? this.m_aOpCase[i] : null;
            int n2 = of = i < cOffsets ? this.m_aofCase[i] : 0;
            if (i > 0) {
                sb.append(",\n");
            }
            sb.append(Argument.toIdString(arg, nArg)).append(": ").append(OpJump.getLabelDesc(op, of));
        }
        sb.append("\ndefault: ").append(OpJump.getLabelDesc(this.m_opDefault, this.m_ofDefault));
        return sb.toString();
    }

    protected abstract void appendArgDescription(StringBuilder var1);

    static enum Algorithm {
        NativeSimple,
        NativeRange,
        NaturalSimple,
        NaturalRange;


        boolean isNative() {
            return switch (this.ordinal()) {
                case 0, 1 -> true;
                default -> false;
            };
        }

        Algorithm worstOf(Algorithm that) {
            return this.compareTo(that) <= 0 ? that : this;
        }
    }
}

