/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Op;
import org.xvm.asm.OpProperty;
import org.xvm.asm.Scope;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;

public class P_Get
extends OpProperty {
    private int m_nTarget;
    private int m_nRetValue;
    private Argument m_argTarget;
    private Argument m_argReturn;

    public P_Get(PropertyConstant idProp, Argument argTarget, Argument argReturn) {
        super(idProp);
        this.m_argTarget = argTarget;
        this.m_argReturn = argReturn;
    }

    public P_Get(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nTarget = Handy.readPackedInt(in);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argTarget != null) {
            this.m_nTarget = P_Get.encodeArgument(this.m_argTarget, registry);
            this.m_nRetValue = P_Get.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nTarget);
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 167;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hTarget = frame.getArgument(this.m_nTarget);
            PropertyConstant constProperty = (PropertyConstant)frame.getConstant(this.m_nPropId);
            if (frame.isNextRegister(this.m_nRetValue)) {
                if (this.m_nTarget == -1) {
                    TypeConstant typeTarget = hTarget.getType();
                    ConstantPool pool = frame.poolContext();
                    TypeConstant typeProp = typeTarget.containsGenericParam(constProperty.getName()) ? constProperty.getFormalType().resolveGenerics(pool, typeTarget).getType() : constProperty.getType().resolveGenerics(pool, typeTarget);
                    frame.introduceResolvedVar(this.m_nRetValue, typeProp);
                } else {
                    frame.introducePropertyVar(this.m_nRetValue, this.m_nTarget, this.m_nPropId);
                }
            }
            return P_Get.isDeferred(hTarget) ? hTarget.proceed(frame, frameCaller -> {
                ObjectHandle hT = frameCaller.popStack();
                return hT.getTemplate().getPropertyValue(frameCaller, hT, constProperty, this.m_nRetValue);
            }) : hTarget.getTemplate().getPropertyValue(frame, hTarget, constProperty, this.m_nRetValue);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    @Override
    public void resetSimulation() {
        P_Get.resetRegister(this.m_argReturn);
    }

    @Override
    public void simulate(Scope scope) {
        P_Get.checkNextRegister(scope, this.m_argReturn, this.m_nRetValue);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argTarget = P_Get.registerArgument(this.m_argTarget, registry);
        this.m_argReturn = P_Get.registerArgument(this.m_argReturn, registry);
    }

    @Override
    public String toString() {
        return super.toString() + ", " + Argument.toIdString(this.m_argTarget, this.m_nTarget) + ", " + Argument.toIdString(this.m_argReturn, this.m_nRetValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        bctx.buildGetProperty(code, bctx.loadArgument(code, this.m_nTarget), this.m_nPropId, this.m_nRetValue);
    }
}

