/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpProperty;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.util.Handy;

public class P_Set
extends OpProperty {
    private int m_nTarget;
    private int m_nValue;
    private Argument m_argTarget;
    private Argument m_argValue;

    public P_Set(PropertyConstant idProp, Argument argTarget, Argument argValue) {
        super(idProp);
        this.m_argTarget = argTarget;
        this.m_argValue = argValue;
    }

    public P_Set(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nTarget = Handy.readPackedInt(in);
        this.m_nValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argTarget != null) {
            this.m_nTarget = P_Set.encodeArgument(this.m_argTarget, registry);
            this.m_nValue = P_Set.encodeArgument(this.m_argValue, registry);
        }
        Handy.writePackedLong(out, this.m_nTarget);
        Handy.writePackedLong(out, this.m_nValue);
    }

    @Override
    public int getOpCode() {
        return 168;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle[] ahArg = frame.getArguments(new int[]{this.m_nTarget, this.m_nValue}, 2);
            PropertyConstant idProp = (PropertyConstant)frame.getConstant(this.m_nPropId);
            if (P_Set.anyDeferred(ahArg)) {
                Frame.Continuation stepNext = frameCaller -> ahArg[0].getTemplate().setPropertyValue(frame, ahArg[0], idProp, ahArg[1]);
                return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
            }
            return ahArg[0].getTemplate().setPropertyValue(frame, ahArg[0], idProp, ahArg[1]);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argTarget = P_Set.registerArgument(this.m_argTarget, registry);
        this.m_argValue = P_Set.registerArgument(this.m_argValue, registry);
    }

    @Override
    public String toString() {
        return super.toString() + ", " + Argument.toIdString(this.m_argTarget, this.m_nTarget) + ", " + Argument.toIdString(this.m_argValue, this.m_nValue);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        bctx.buildSetProperty(code, bctx.loadArgument(code, this.m_nTarget), this.m_nPropId, this.m_nValue);
    }
}

