/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpProperty;
import org.xvm.asm.Scope;
import org.xvm.asm.constants.PropertyConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;

public class P_Var
extends OpProperty {
    private int m_nTarget;
    private int m_nRetValue;
    private Argument m_argTarget;
    private Argument m_argReturn;

    public P_Var(PropertyConstant idProp, Argument argTarget, Argument argReturn) {
        super(idProp);
        this.m_argTarget = argTarget;
        this.m_argReturn = argReturn;
    }

    public P_Var(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nTarget = Handy.readPackedInt(in);
        this.m_nRetValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argTarget != null) {
            this.m_nTarget = P_Var.encodeArgument(this.m_argTarget, registry);
            this.m_nRetValue = P_Var.encodeArgument(this.m_argReturn, registry);
        }
        Handy.writePackedLong(out, this.m_nTarget);
        Handy.writePackedLong(out, this.m_nRetValue);
    }

    @Override
    public int getOpCode() {
        return 169;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hTarget = frame.getArgument(this.m_nTarget);
            return P_Var.isDeferred(hTarget) ? hTarget.proceed(frame, frameCaller -> this.complete(frameCaller, frameCaller.popStack())) : this.complete(frame, hTarget);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, ObjectHandle hTarget) {
        PropertyConstant constProperty = (PropertyConstant)frame.getConstant(this.m_nPropId);
        if (frame.isNextRegister(this.m_nRetValue)) {
            frame.introduceResolvedVar(this.m_nRetValue, constProperty.getRefType(null));
        }
        return hTarget.getTemplate().createPropertyRef(frame, hTarget, constProperty, false, this.m_nRetValue);
    }

    @Override
    public void resetSimulation() {
        P_Var.resetRegister(this.m_argReturn);
    }

    @Override
    public void simulate(Scope scope) {
        P_Var.checkNextRegister(scope, this.m_argReturn, this.m_nRetValue);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argTarget = P_Var.registerArgument(this.m_argTarget, registry);
        this.m_argReturn = P_Var.registerArgument(this.m_argReturn, registry);
    }

    @Override
    public String toString() {
        return super.toString() + ", " + Argument.toIdString(this.m_argTarget, this.m_nTarget) + ", " + Argument.toIdString(this.m_argReturn, this.m_nRetValue);
    }
}

