/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpReturn;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;

public class Return_1
extends OpReturn {
    private int m_nArg;
    private Argument m_arg;

    public Return_1(Argument arg) {
        this.m_arg = arg;
    }

    public Return_1(DataInput in, Constant[] aconst) throws IOException {
        this.m_nArg = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_arg != null) {
            this.m_nArg = Return_1.encodeArgument(this.m_arg, registry);
        }
        Handy.writePackedLong(out, this.m_nArg);
    }

    @Override
    public int getOpCode() {
        return 77;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hArg = frame.getReturnValue(this.m_nArg);
            return Return_1.isDeferred(hArg) ? hArg.proceed(frame, frameCaller -> this.complete(frameCaller, frameCaller.popStack(), false)) : this.complete(frame, hArg, frame.isDynamicVar(this.m_nArg));
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, ObjectHandle hValue, boolean fDynamic) {
        return this.m_fCallFinally ? frame.processAllGuard(new Return1Action(hValue, fDynamic, this.m_ixAllGuard)) : frame.returnValue(hValue, fDynamic);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        this.m_arg = Return_1.registerArgument(this.m_arg, registry);
    }

    @Override
    public String toString() {
        return super.toString() + " " + Argument.toIdString(this.m_arg, this.m_nArg);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        this.buildReturn(bctx, code, new int[]{this.m_nArg});
    }

    protected static class Return1Action
    extends Frame.DeferredGuardAction {
        private final ObjectHandle m_hValue;
        private final boolean m_fDynamic;

        public Return1Action(ObjectHandle hValue, boolean fDynamic, int ixAllGuard) {
            super(ixAllGuard);
            this.m_hValue = hValue;
            this.m_fDynamic = fDynamic;
        }

        @Override
        public int complete(Frame frame) {
            return frame.returnValue(this.m_hValue, this.m_fDynamic);
        }
    }
}

