/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpReturn;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;

public class Return_N
extends OpReturn {
    private int[] m_anArg;
    private Argument[] m_aArg;

    public Return_N(Argument[] aArg) {
        this.m_aArg = aArg;
    }

    public Return_N(DataInput in, Constant[] aconst) throws IOException {
        this.m_anArg = Return_N.readIntArray(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_aArg != null) {
            Argument[] aArg = this.m_aArg;
            int cArgs = aArg.length;
            int[] anArg = new int[cArgs];
            for (int i = 0; i < cArgs; ++i) {
                anArg[i] = Return_N.encodeArgument(aArg[i], registry);
            }
            this.m_anArg = anArg;
        }
        Return_N.writeIntArray(out, this.m_anArg);
    }

    @Override
    public int getOpCode() {
        return 78;
    }

    @Override
    public int process(Frame frame, int iPC) {
        int cArgs = this.m_anArg.length;
        ObjectHandle[] ahArg = new ObjectHandle[cArgs];
        boolean[] afDynamic = null;
        boolean fAnyProp = false;
        for (int i = cArgs - 1; i >= 0; --i) {
            ObjectHandle hArg;
            int nArg = this.m_anArg[i];
            try {
                hArg = frame.getReturnValue(nArg);
            }
            catch (ObjectHandle.ExceptionHandle.WrapperException e) {
                return frame.raiseException(e);
            }
            ahArg[i] = hArg;
            if (Return_N.isDeferred(hArg)) {
                fAnyProp = true;
                continue;
            }
            if (!frame.isDynamicVar(nArg)) continue;
            if (afDynamic == null) {
                afDynamic = new boolean[cArgs];
            }
            afDynamic[i] = true;
        }
        if (fAnyProp) {
            boolean[] af = afDynamic;
            Frame.Continuation stepNext = frameCaller -> this.complete(frameCaller, ahArg, af);
            return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
        }
        return this.complete(frame, ahArg, afDynamic);
    }

    protected int complete(Frame frame, ObjectHandle[] ahValue, boolean[] afDynamic) {
        return this.m_fCallFinally ? frame.processAllGuard(new ReturnNAction(ahValue, afDynamic, this.m_ixAllGuard)) : frame.returnValues(ahValue, afDynamic);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        Return_N.registerArguments(this.m_aArg, registry);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString()).append(" (");
        int cArgs = this.m_anArg == null ? this.m_aArg.length : this.m_anArg.length;
        for (int i = 0; i < cArgs; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(Argument.toIdString(this.m_aArg == null ? null : this.m_aArg[i], this.m_anArg == null ? 1000000000 : this.m_anArg[i]));
        }
        sb.append(')');
        return sb.toString();
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        this.buildReturn(bctx, code, this.m_anArg);
    }

    protected static class ReturnNAction
    extends Frame.DeferredGuardAction {
        private final ObjectHandle[] m_ahValue;
        private final boolean[] m_afDynamic;

        public ReturnNAction(ObjectHandle[] ahValue, boolean[] afDynamic, int ixAllGuard) {
            super(ixAllGuard);
            this.m_ahValue = ahValue;
            this.m_afDynamic = afDynamic;
        }

        @Override
        public int complete(Frame frame) {
            return frame.returnValues(this.m_ahValue, this.m_afDynamic);
        }
    }
}

