/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpReturn;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template.collections.xTuple;
import org.xvm.util.Handy;

public class Return_T
extends OpReturn {
    private int m_nArg;
    private Argument m_argT;

    public Return_T(Argument argT) {
        this.m_argT = argT;
    }

    public Return_T(DataInput in, Constant[] aconst) throws IOException {
        this.m_nArg = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argT != null) {
            this.m_nArg = Return_T.encodeArgument(this.m_argT, registry);
        }
        Handy.writePackedLong(out, this.m_nArg);
    }

    @Override
    public int getOpCode() {
        return 79;
    }

    @Override
    public int process(Frame frame, int iPC) {
        ObjectHandle hArg;
        try {
            hArg = frame.getReturnValue(this.m_nArg);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
        return Return_T.isDeferred(hArg) ? hArg.proceed(frame, frameCaller -> this.complete(frameCaller, (xTuple.TupleHandle)frameCaller.popStack())) : this.complete(frame, (xTuple.TupleHandle)hArg);
    }

    protected int complete(Frame frame, xTuple.TupleHandle hValue) {
        return this.m_fCallFinally ? frame.processAllGuard(new ReturnTAction(hValue, this.m_ixAllGuard)) : frame.returnTuple(hValue);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        this.m_argT = Return_T.registerArgument(this.m_argT, registry);
    }

    protected static class ReturnTAction
    extends Frame.DeferredGuardAction {
        private final xTuple.TupleHandle m_hValue;

        public ReturnTAction(xTuple.TupleHandle hValue, int ixAllGuard) {
            super(ixAllGuard);
            this.m_hValue = hValue;
        }

        @Override
        public int complete(Frame frame) {
            return frame.returnTuple(this.m_hValue);
        }
    }
}

