/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;

public class Throw
extends Op {
    private int m_nArgValue;
    private Argument m_argValue;

    public Throw(Argument argValue) {
        if (argValue == null) {
            throw new IllegalArgumentException("argument required");
        }
        this.m_argValue = argValue;
    }

    public Throw(DataInput in, Constant[] aconst) throws IOException {
        this.m_nArgValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argValue != null) {
            this.m_nArgValue = Throw.encodeArgument(this.m_argValue, registry);
        }
        Handy.writePackedLong(out, this.m_nArgValue);
    }

    @Override
    public int getOpCode() {
        return 14;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hException = frame.getArgument(this.m_nArgValue);
            return Throw.isDeferred(hException) ? hException.proceed(frame, frameCaller -> frameCaller.raiseException((ObjectHandle.ExceptionHandle)frameCaller.popStack())) : frame.raiseException((ObjectHandle.ExceptionHandle)hException);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    @Override
    public boolean advances() {
        return false;
    }

    @Override
    public String toString() {
        return super.toString() + " " + Argument.toIdString(this.m_argValue, this.m_nArgValue);
    }
}

