/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpVar;
import org.xvm.asm.Register;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template.reflect.xRef;
import org.xvm.util.Handy;

public class Var_C
extends OpVar {
    private int m_nArgValue;
    private Argument m_argValue;

    public Var_C(Register reg, Argument argValue) {
        super(reg);
        if (argValue == null) {
            throw new IllegalArgumentException("value required");
        }
        if (!argValue.getType().isA(argValue.getType().getConstantPool().typeRef())) {
            throw new IllegalArgumentException("value must be a Ref or Var");
        }
        this.m_argValue = argValue;
    }

    public Var_C(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nArgValue = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argValue != null) {
            this.m_nArgValue = Var_C.encodeArgument(this.m_argValue, registry);
        }
        Handy.writePackedLong(out, this.m_nArgValue);
    }

    @Override
    public int getOpCode() {
        return 86;
    }

    @Override
    protected boolean isTypeAware() {
        return false;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hRef = frame.getArgument(this.m_nArgValue);
            return Var_C.isDeferred(hRef) ? hRef.proceed(frame, frameCaller -> this.complete(frameCaller, iPC, (xRef.RefHandle)frameCaller.popStack())) : this.complete(frame, iPC, (xRef.RefHandle)hRef);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, int iPC, xRef.RefHandle hRef) {
        frame.introduceResolvedVar(this.m_nVar, hRef.getType(), hRef.getName(), 1, hRef);
        return iPC + 1;
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argValue = Var_C.registerArgument(this.m_argValue, registry);
    }
}

