/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpVar;
import org.xvm.asm.Register;
import org.xvm.asm.constants.StringConstant;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.Frame;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.VarSupport;
import org.xvm.util.Handy;

public class Var_DN
extends OpVar {
    private int m_nNameId;
    private StringConstant m_constName;

    public Var_DN(Register reg, StringConstant constName) {
        super(reg);
        if (constName == null) {
            throw new IllegalArgumentException("name required");
        }
        this.m_constName = constName;
    }

    public Var_DN(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nNameId = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_constName != null) {
            this.m_nNameId = Var_DN.encodeArgument(this.m_constName, registry);
        }
        Handy.writePackedLong(out, this.m_nNameId);
    }

    @Override
    public int getOpCode() {
        return 85;
    }

    @Override
    public int process(Frame frame, int iPC) {
        String sName = frame.getString(this.m_nNameId);
        TypeComposition clz = frame.resolveClass(this.m_nType);
        return ((VarSupport)clz.getSupport()).introduceRef(frame, clz, sName, this.m_nVar);
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_constName = (StringConstant)Var_DN.registerArgument(this.m_constName, registry);
    }

    @Override
    public String getName(Constant[] aconst) {
        return this.getName(aconst, this.m_constName, this.m_nNameId);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        bctx.introduceRef(code, bctx.getString(this.m_nNameId), bctx.getType(this.m_nType), this.m_nVar);
    }
}

