/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpVar;
import org.xvm.asm.Register;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;

public class Var_I
extends OpVar {
    private int m_nValueId;
    private Argument m_argValue;

    public Var_I(Register reg, Argument argValue) {
        super(reg);
        if (argValue == null) {
            throw new IllegalArgumentException("value required");
        }
        this.m_argValue = argValue;
    }

    public Var_I(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nValueId = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argValue != null) {
            this.m_nValueId = Var_I.encodeArgument(this.m_argValue, registry);
        }
        Handy.writePackedLong(out, this.m_nValueId);
    }

    @Override
    public int getOpCode() {
        return 81;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hArg = frame.getArgument(this.m_nValueId);
            if (Var_I.isDeferred(hArg)) {
                return hArg.proceed(frame, frameCaller -> {
                    frameCaller.introduceVar(this.m_nVar, Var_I.convertId(this.m_nType), 0, 0, frameCaller.popStack());
                    return iPC + 1;
                });
            }
            frame.introduceVar(this.m_nVar, Var_I.convertId(this.m_nType), 0, 0, hArg);
            return iPC + 1;
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_argValue = Var_I.registerArgument(this.m_argValue, registry);
    }

    @Override
    public String toString() {
        return super.toString() + " " + Argument.toIdString(this.m_argValue, this.m_nValueId);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        bctx.introduceVar(code, this.m_nVar, this.m_nType, 0);
        bctx.loadArgument(code, this.m_nValueId);
    }
}

