/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.classfile.CodeBuilder;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpVar;
import org.xvm.asm.Register;
import org.xvm.asm.constants.StringConstant;
import org.xvm.javajit.BuildContext;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.util.Handy;

public class Var_IN
extends OpVar {
    private int m_nNameId;
    private int m_nValueId;
    private StringConstant m_constName;
    private Argument m_argValue;

    public Var_IN(Register reg, StringConstant constName, Argument argValue) {
        super(reg);
        if (argValue == null || constName == null) {
            throw new IllegalArgumentException("name and value required");
        }
        this.m_constName = constName;
        this.m_argValue = argValue;
    }

    public Var_IN(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nNameId = Handy.readPackedInt(in);
        this.m_nValueId = Handy.readPackedInt(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_argValue != null) {
            this.m_nNameId = Var_IN.encodeArgument(this.m_constName, registry);
            this.m_nValueId = Var_IN.encodeArgument(this.m_argValue, registry);
        }
        Handy.writePackedLong(out, this.m_nNameId);
        Handy.writePackedLong(out, this.m_nValueId);
    }

    @Override
    public int getOpCode() {
        return 83;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle hArg = frame.getArgument(this.m_nValueId);
            if (Var_IN.isDeferred(hArg)) {
                return hArg.proceed(frame, frameCaller -> {
                    frameCaller.introduceVar(this.m_nVar, Var_IN.convertId(this.m_nType), this.m_nNameId, 0, frameCaller.popStack());
                    return iPC + 1;
                });
            }
            frame.introduceVar(this.m_nVar, Var_IN.convertId(this.m_nType), this.m_nNameId, 0, hArg);
            return iPC + 1;
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_constName = (StringConstant)Var_IN.registerArgument(this.m_constName, registry);
        this.m_argValue = Var_IN.registerArgument(this.m_argValue, registry);
    }

    @Override
    public String getName(Constant[] aconst) {
        return this.getName(aconst, this.m_constName, this.m_nNameId);
    }

    @Override
    public void build(BuildContext bctx, CodeBuilder code) {
        BuildContext.Slot slot = bctx.introduceVar(code, this.m_nVar, this.m_nType, this.m_nNameId);
        bctx.loadArgument(code, this.m_nValueId);
        bctx.storeValue(code, slot);
    }
}

