/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpVar;
import org.xvm.asm.Register;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template.maps.xListMap;
import org.xvm.util.Handy;

public class Var_M
extends OpVar {
    private int[] m_anArgKey;
    private int[] m_anArgVal;
    private Argument[] m_aArgKey;
    private Argument[] m_aArgVal;

    public Var_M(Register reg, Argument[] aArgKey, Argument[] aArgVal) {
        super(reg);
        if (aArgKey == null || aArgVal == null) {
            throw new IllegalArgumentException("name, keys and values required");
        }
        assert (aArgKey.length == aArgVal.length);
        this.m_aArgKey = aArgKey;
        this.m_aArgVal = aArgVal;
    }

    public Var_M(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        int c = Handy.readMagnitude(in);
        int[] aiKey = new int[c];
        for (int i = 0; i < c; ++i) {
            aiKey[i] = Handy.readPackedInt(in);
        }
        this.m_anArgKey = aiKey;
        int[] aiVal = new int[c];
        for (int i = 0; i < c; ++i) {
            aiVal[i] = Handy.readPackedInt(in);
        }
        this.m_anArgVal = aiVal;
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        int i;
        super.write(out, registry);
        if (this.m_aArgKey != null) {
            this.m_anArgKey = Var_M.encodeArguments(this.m_aArgKey, registry);
            this.m_anArgVal = Var_M.encodeArguments(this.m_aArgVal, registry);
        }
        int c = this.m_anArgKey.length;
        Handy.writePackedLong(out, c);
        for (i = 0; i < c; ++i) {
            Handy.writePackedLong(out, this.m_anArgKey[i]);
        }
        for (i = 0; i < c; ++i) {
            Handy.writePackedLong(out, this.m_anArgVal[i]);
        }
    }

    @Override
    public int getOpCode() {
        return 92;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            TypeConstant typeMap = frame.resolveType(this.m_nType);
            ObjectHandle[] ahKey = frame.getArguments(this.m_anArgKey, this.m_anArgKey.length);
            ObjectHandle[] ahValue = frame.getArguments(this.m_anArgVal, this.m_anArgVal.length);
            frame.introduceResolvedVar(this.m_nVar, typeMap, null, 0, null);
            return xListMap.INSTANCE.constructMap(frame, typeMap, ahKey, ahValue, Var_M.anyDeferred(ahKey), Var_M.anyDeferred(ahValue), this.m_nVar);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        Var_M.registerArguments(this.m_aArgKey, registry);
        Var_M.registerArguments(this.m_aArgVal, registry);
    }
}

