/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpVar;
import org.xvm.asm.Register;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.template.maps.xListMap;
import org.xvm.util.Handy;

public class Var_MN
extends OpVar {
    private int m_nNameId;
    private int[] m_anArgKey;
    private int[] m_anArgVal;
    private StringConstant m_constName;
    private Argument[] m_aArgKey;
    private Argument[] m_aArgVal;

    public Var_MN(Register reg, StringConstant constName, Argument[] aArgKey, Argument[] aArgVal) {
        super(reg);
        if (constName == null || aArgKey == null || aArgVal == null) {
            throw new IllegalArgumentException("name, keys and values required");
        }
        assert (aArgKey.length == aArgVal.length);
        this.m_constName = constName;
        this.m_aArgKey = aArgKey;
        this.m_aArgVal = aArgVal;
    }

    public Var_MN(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nNameId = Handy.readPackedInt(in);
        int c = Handy.readMagnitude(in);
        int[] aiKey = new int[c];
        for (int i = 0; i < c; ++i) {
            aiKey[i] = Handy.readPackedInt(in);
        }
        this.m_anArgKey = aiKey;
        int[] aiVal = new int[c];
        for (int i = 0; i < c; ++i) {
            aiVal[i] = Handy.readPackedInt(in);
        }
        this.m_anArgVal = aiVal;
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        int i;
        super.write(out, registry);
        if (this.m_constName != null) {
            this.m_nNameId = Var_MN.encodeArgument(this.m_constName, registry);
            this.m_anArgKey = Var_MN.encodeArguments(this.m_aArgKey, registry);
            this.m_anArgVal = Var_MN.encodeArguments(this.m_aArgVal, registry);
        }
        Handy.writePackedLong(out, this.m_nNameId);
        int c = this.m_anArgKey.length;
        Handy.writePackedLong(out, c);
        for (i = 0; i < c; ++i) {
            Handy.writePackedLong(out, this.m_anArgKey[i]);
        }
        for (i = 0; i < c; ++i) {
            Handy.writePackedLong(out, this.m_anArgVal[i]);
        }
    }

    @Override
    public int getOpCode() {
        return 93;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            TypeConstant typeMap = frame.resolveType(this.m_nType);
            ObjectHandle[] ahKey = frame.getArguments(this.m_anArgKey, this.m_anArgKey.length);
            ObjectHandle[] ahValue = frame.getArguments(this.m_anArgVal, this.m_anArgVal.length);
            frame.introduceResolvedVar(this.m_nVar, typeMap, frame.getString(this.m_nNameId), 0, null);
            return xListMap.INSTANCE.constructMap(frame, typeMap, ahKey, ahValue, Var_MN.anyDeferred(ahKey), Var_MN.anyDeferred(ahValue), this.m_nVar);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_constName = (StringConstant)Var_MN.registerArgument(this.m_constName, registry);
        Var_MN.registerArguments(this.m_aArgKey, registry);
        Var_MN.registerArguments(this.m_aArgVal, registry);
    }

    @Override
    public String getName(Constant[] aconst) {
        return this.getName(aconst, this.m_constName, this.m_nNameId);
    }
}

