/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpVar;
import org.xvm.asm.Register;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.collections.xArray;

public class Var_S
extends OpVar {
    private int[] m_anArgValue;
    private Argument[] m_aArgValue;

    public Var_S(Register reg, Argument[] aArgValue) {
        super(reg);
        if (aArgValue == null) {
            throw new IllegalArgumentException("values required");
        }
        this.m_aArgValue = aArgValue;
    }

    public Var_S(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_anArgValue = Var_S.readIntArray(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_aArgValue != null) {
            this.m_anArgValue = Var_S.encodeArguments(this.m_aArgValue, registry);
        }
        Var_S.writeIntArray(out, this.m_anArgValue);
    }

    @Override
    public int getOpCode() {
        return 88;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle[] ahArg = frame.getArguments(this.m_anArgValue, this.m_anArgValue.length);
            if (Var_S.anyDeferred(ahArg)) {
                Frame.Continuation stepNext = frameCaller -> this.complete(frameCaller, iPC, ahArg);
                return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
            }
            return this.complete(frame, iPC, ahArg);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, int iPC, ObjectHandle[] ahArg) {
        boolean fImmutable = true;
        for (ObjectHandle hValue : ahArg) {
            if (hValue.isPassThrough()) continue;
            fImmutable = false;
            break;
        }
        TypeConstant typeList = frame.resolveType(this.m_nType);
        TypeComposition clzArray = this.getArrayClass(frame, typeList);
        xArray.ArrayHandle hArray = xArray.makeArrayHandle(clzArray, ahArg.length, ahArg, fImmutable ? xArray.Mutability.Constant : xArray.Mutability.Persistent);
        if (typeList.isA(frame.poolContext().typeSet())) {
            frame.introduceResolvedVar(this.m_nVar, typeList, null, 0, null);
            return xArray.createListSet(frame, hArray, this.m_nVar);
        }
        frame.introduceResolvedVar(this.m_nVar, typeList, null, 0, hArray);
        return iPC + 1;
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        Var_S.registerArguments(this.m_aArgValue, registry);
    }
}

