/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpVar;
import org.xvm.asm.Register;
import org.xvm.asm.constants.StringConstant;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.collections.xArray;
import org.xvm.util.Handy;

public class Var_SN
extends OpVar {
    private int m_nNameId;
    private int[] m_anArgValue;
    private StringConstant m_constName;
    private Argument[] m_aArgValue;

    public Var_SN(Register reg, StringConstant constName, Argument[] aArgValue) {
        super(reg);
        if (constName == null || aArgValue == null) {
            throw new IllegalArgumentException("name and values required");
        }
        this.m_constName = constName;
        this.m_aArgValue = aArgValue;
    }

    public Var_SN(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nNameId = Handy.readPackedInt(in);
        this.m_anArgValue = Var_SN.readIntArray(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_constName != null) {
            this.m_nNameId = Var_SN.encodeArgument(this.m_constName, registry);
            this.m_anArgValue = Var_SN.encodeArguments(this.m_aArgValue, registry);
        }
        Handy.writePackedLong(out, this.m_nNameId);
        Var_SN.writeIntArray(out, this.m_anArgValue);
    }

    @Override
    public int getOpCode() {
        return 89;
    }

    @Override
    public int process(Frame frame, int iPC) {
        try {
            ObjectHandle[] ahArg = frame.getArguments(this.m_anArgValue, this.m_anArgValue.length);
            if (Var_SN.anyDeferred(ahArg)) {
                Frame.Continuation stepNext = frameCaller -> this.complete(frameCaller, iPC, ahArg);
                return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
            }
            return this.complete(frame, iPC, ahArg);
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    protected int complete(Frame frame, int iPC, ObjectHandle[] ahArg) {
        boolean fImmutable = true;
        for (ObjectHandle hValue : ahArg) {
            if (hValue.isPassThrough()) continue;
            fImmutable = false;
            break;
        }
        TypeConstant typeList = frame.resolveType(this.m_nType);
        TypeComposition clzArray = this.getArrayClass(frame, typeList);
        xArray.ArrayHandle hArray = xArray.makeArrayHandle(clzArray, ahArg.length, ahArg, fImmutable ? xArray.Mutability.Constant : xArray.Mutability.Persistent);
        if (typeList.isA(frame.poolContext().typeSet())) {
            frame.introduceResolvedVar(this.m_nVar, typeList, frame.getString(this.m_nNameId), 0, null);
            return xArray.createListSet(frame, hArray, this.m_nVar);
        }
        frame.introduceResolvedVar(this.m_nVar, typeList, frame.getString(this.m_nNameId), 0, hArray);
        return iPC + 1;
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_constName = (StringConstant)Var_SN.registerArgument(this.m_constName, registry);
        Var_SN.registerArguments(this.m_aArgValue, registry);
    }

    @Override
    public String getName(Constant[] aconst) {
        return this.getName(aconst, this.m_constName, this.m_nNameId);
    }
}

