/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpVar;
import org.xvm.asm.Register;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.collections.xTuple;

public class Var_T
extends OpVar {
    private int[] m_anArgValue;
    private Argument[] m_aArgValue;

    public Var_T(Register reg, Argument[] aArgValue) {
        super(reg);
        if (aArgValue == null) {
            throw new IllegalArgumentException("values required");
        }
        this.m_aArgValue = aArgValue;
    }

    public Var_T(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_anArgValue = Var_T.readIntArray(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_aArgValue != null) {
            this.m_anArgValue = Var_T.encodeArguments(this.m_aArgValue, registry);
        }
        Var_T.writeIntArray(out, this.m_anArgValue);
    }

    @Override
    public int getOpCode() {
        return 90;
    }

    @Override
    public int process(Frame frame, int iPC) {
        TypeComposition clzTuple = frame.resolveClass(this.m_nType);
        try {
            ObjectHandle[] ahArg = frame.getArguments(this.m_anArgValue, this.m_anArgValue.length);
            if (Var_T.anyDeferred(ahArg)) {
                Frame.Continuation stepNext = frameCaller -> {
                    frameCaller.introduceVar(this.m_nVar, Var_T.convertId(this.m_nType), 0, 0, xTuple.makeHandle(clzTuple, ahArg));
                    return iPC + 1;
                };
                return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
            }
            frame.introduceVar(this.m_nVar, Var_T.convertId(this.m_nType), 0, 0, xTuple.makeHandle(clzTuple, ahArg));
            return iPC + 1;
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        Var_T.registerArguments(this.m_aArgValue, registry);
    }
}

