/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.asm.op;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.xvm.asm.Argument;
import org.xvm.asm.Constant;
import org.xvm.asm.Op;
import org.xvm.asm.OpVar;
import org.xvm.asm.Register;
import org.xvm.asm.constants.StringConstant;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.TypeComposition;
import org.xvm.runtime.Utils;
import org.xvm.runtime.template.collections.xTuple;
import org.xvm.util.Handy;

public class Var_TN
extends OpVar {
    private int m_nNameId;
    private int[] m_anArgValue;
    private StringConstant m_constName;
    private Argument[] m_aArgValue;

    public Var_TN(Register reg, StringConstant constName, Argument[] aArgValue) {
        super(reg);
        if (constName == null || aArgValue == null) {
            throw new IllegalArgumentException("name and values required");
        }
        this.m_constName = constName;
        this.m_aArgValue = aArgValue;
    }

    public Var_TN(DataInput in, Constant[] aconst) throws IOException {
        super(in, aconst);
        this.m_nNameId = Handy.readPackedInt(in);
        this.m_anArgValue = Var_TN.readIntArray(in);
    }

    @Override
    public void write(DataOutput out, Op.ConstantRegistry registry) throws IOException {
        super.write(out, registry);
        if (this.m_constName != null) {
            this.m_nNameId = Var_TN.encodeArgument(this.m_constName, registry);
            this.m_anArgValue = Var_TN.encodeArguments(this.m_aArgValue, registry);
        }
        Handy.writePackedLong(out, this.m_nNameId);
        Var_TN.writeIntArray(out, this.m_anArgValue);
    }

    @Override
    public int getOpCode() {
        return 91;
    }

    @Override
    public int process(Frame frame, int iPC) {
        TypeComposition clzTuple = frame.resolveClass(this.m_nType);
        try {
            ObjectHandle[] ahArg = frame.getArguments(this.m_anArgValue, this.m_anArgValue.length);
            if (Var_TN.anyDeferred(ahArg)) {
                Frame.Continuation stepNext = frameCaller -> {
                    frameCaller.introduceVar(this.m_nVar, Var_TN.convertId(this.m_nType), this.m_nNameId, 0, xTuple.makeHandle(clzTuple, ahArg));
                    return iPC + 1;
                };
                return new Utils.GetArguments(ahArg, stepNext).doNext(frame);
            }
            frame.introduceVar(this.m_nVar, Var_TN.convertId(this.m_nType), this.m_nNameId, 0, xTuple.makeHandle(clzTuple, ahArg));
            return iPC + 1;
        }
        catch (ObjectHandle.ExceptionHandle.WrapperException e) {
            return frame.raiseException(e);
        }
    }

    @Override
    public void registerConstants(Op.ConstantRegistry registry) {
        super.registerConstants(registry);
        this.m_constName = (StringConstant)Var_TN.registerArgument(this.m_constName, registry);
        Var_TN.registerArguments(this.m_aArgValue, registry);
    }

    @Override
    public String getName(Constant[] aconst) {
        return this.getName(aconst, this.m_constName, this.m_nNameId);
    }
}

