/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.xvm.asm.ModuleRepository;
import org.xvm.asm.ModuleStructure;
import org.xvm.asm.Version;
import org.xvm.asm.constants.ModuleConstant;

public class BuildRepository
implements ModuleRepository {
    private final Map<ModuleConstant, ModuleStructure> modulesById = new TreeMap<ModuleConstant, ModuleStructure>();

    @Override
    public Set<String> getModuleNames() {
        return this.modulesById.keySet().stream().map(ModuleConstant::getName).collect(Collectors.toSet());
    }

    @Override
    public ModuleStructure loadModule(String sModule) {
        for (Map.Entry<ModuleConstant, ModuleStructure> entry : this.modulesById.entrySet()) {
            if (!entry.getKey().getName().equals(sModule)) continue;
            return entry.getValue();
        }
        return null;
    }

    @Override
    public ModuleStructure loadModule(String sModule, Version version, boolean fExact) {
        if (version == null) {
            return this.loadModule(sModule);
        }
        for (Map.Entry<ModuleConstant, ModuleStructure> entry : this.modulesById.entrySet()) {
            if (!entry.getKey().getName().equals(sModule)) continue;
            ModuleStructure module = entry.getValue();
            if (!(fExact ? module.getVersion().equals(version) : module.getVersion().isSubstitutableFor(version))) continue;
            return module;
        }
        return null;
    }

    @Override
    public void storeModule(ModuleStructure module) {
        Version version;
        assert (module != null);
        ModuleConstant idModule = module.getIdentityConstant();
        if (idModule.getVersion() == null && (version = module.getVersion()) != null) {
            idModule = idModule.getConstantPool().ensureModuleConstant(idModule.getName(), version);
        }
        this.modulesById.put(idModule, module);
    }

    public void storeAll(BuildRepository repoThat) {
        this.modulesById.putAll(repoThat.modulesById);
    }
}

