/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler;

import org.xvm.asm.ConstantPool;
import org.xvm.asm.ErrorList;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.FileStructure;
import org.xvm.asm.ModuleRepository;
import org.xvm.asm.constants.ModuleConstant;
import org.xvm.compiler.CompilerException;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.StageMgr;
import org.xvm.compiler.ast.TypeCompositionStatement;
import org.xvm.util.Auto;
import org.xvm.util.Severity;

public class Compiler {
    private Stage m_stage = Stage.Initial;
    private final TypeCompositionStatement m_stmtModule;
    private final ErrorList m_errs;
    private FileStructure m_structFile;
    private StageMgr m_mgr;
    public static final String FATAL_ERROR = "COMPILER-01";
    public static final String MODULE_UNEXPECTED = "COMPILER-02";
    public static final String PACKAGE_UNEXPECTED = "COMPILER-03";
    public static final String CLASS_UNEXPECTED = "COMPILER-04";
    public static final String PROP_DUPLICATE = "COMPILER-05";
    public static final String PROP_UNEXPECTED = "COMPILER-06";
    public static final String MODULE_BAD_NAME = "COMPILER-07";
    public static final String DUPLICATE_MODIFIER = "COMPILER-08";
    public static final String ILLEGAL_MODIFIER = "COMPILER-09";
    public static final String CONFLICTING_MODIFIER = "COMPILER-10";
    public static final String MULTIPLE_EXTEND_CLAUSES = "COMPILER-11";
    public static final String TYPE_PARAMS_UNEXPECTED = "COMPILER-12";
    public static final String VALIDATOR_PARAMS_UNEXPECTED = "COMPILER-13";
    public static final String CONSTRUCTOR_PARAM_DEFAULT_REQUIRED = "COMPILER-14";
    public static final String KEYWORD_UNEXPECTED = "COMPILER-15";
    public static final String INNER_CONST_NOT_STATIC = "COMPILER-16";
    public static final String INNER_SERVICE_NOT_STATIC = "COMPILER-17";
    public static final String TYPE_PARAMS_MISMATCH = "COMPILER-18";
    public static final String DUPLICATE_TYPE_PARAM = "COMPILER-19";
    public static final String MULTIPLE_IMPORT_CLAUSES = "COMPILER-20";
    public static final String MULTIPLE_INTO_CLAUSES = "COMPILER-21";
    public static final String IMPURE_MODULE_IMPORT = "COMPILER-22";
    public static final String CONDITIONAL_NOT_ALLOWED = "COMPILER-23";
    public static final String MODULE_MISSING = "COMPILER-24";
    public static final String CONFLICTING_VERSIONS = "COMPILER-25";
    public static final String ILLEGAL_SELF_IMPORT = "COMPILER-26";
    public static final String ILLEGAL_CONDITIONAL = "COMPILER-27";
    public static final String DUPLICATE_IMPORT = "COMPILER-28";
    public static final String CONDITIONAL_IMPORT = "COMPILER-29";
    public static final String INFINITE_RESOLVE_LOOP = "COMPILER-30";
    public static final String NAME_COLLISION = "COMPILER-31";
    public static final String NOT_CLASS_TYPE = "COMPILER-32";
    public static final String METHOD_UNEXPECTED = "COMPILER-33";
    public static final String TYPEDEF_UNEXPECTED = "COMPILER-34";
    public static final String ANNOTATION_UNEXPECTED = "COMPILER-35";
    public static final String NAME_MISSING = "COMPILER-36";
    public static final String NAME_AMBIGUOUS = "COMPILER-37";
    public static final String NAME_UNRESOLVABLE = "COMPILER-38";
    public static final String NAME_UNHIDEABLE = "COMPILER-39";
    public static final String RETURN_VOID = "COMPILER-40";
    public static final String RETURN_EXPECTED = "COMPILER-41";
    public static final String RETURN_WRONG_COUNT = "COMPILER-42";
    public static final String WRONG_TYPE = "COMPILER-43";
    public static final String WRONG_TYPE_ARITY = "COMPILER-44";
    public static final String VALUE_OUT_OF_RANGE = "COMPILER-45";
    public static final String NOT_REACHABLE = "COMPILER-46";
    public static final String CONSTANT_REQUIRED = "COMPILER-47";
    public static final String LVALUE_REQUIRED = "COMPILER-48";
    public static final String RETURN_REQUIRED = "COMPILER-49";
    public static final String INVALID_OPERATION = "COMPILER-50";
    public static final String VAR_DEFINED = "COMPILER-51";
    public static final String NO_THIS = "COMPILER-52";
    public static final String NO_SUPER = "COMPILER-53";
    public static final String MISSING_TYPE_PARAMETERS = "COMPILER-54";
    public static final String MISSING_PARAM_INFORMATION = "COMPILER-55";
    public static final String MISSING_METHOD = "COMPILER-56";
    public static final String MISSING_RELATIVE = "COMPILER-57";
    public static final String INVALID_METHOD_TARGET = "COMPILER-58";
    public static final String INVALID_OUTER_THIS = "COMPILER-59";
    public static final String ARG_NAME_REQUIRED = "COMPILER-60";
    public static final String VAR_DECL_COND_ASN_ILLEGAL = "COMPILER-61";
    public static final String DEFAULT_CONSTRUCTOR_REQUIRED = "COMPILER-62";
    public static final String SIGNATURE_AMBIGUOUS = "COMPILER-63";
    public static final String DUPLICATE_DEFAULT_VALUE = "COMPILER-64";
    public static final String MISSING_CONSTRUCTOR = "COMPILER-65";
    public static final String TUPLE_TYPE_WRONG_ARITY = "COMPILER-66";
    public static final String MISSING_OPERATOR = "COMPILER-67";
    public static final String MISSING_OPERATOR_SIGNATURE = "COMPILER-68";
    public static final String AMBIGUOUS_OPERATOR_SIGNATURE = "COMPILER-69";
    public static final String ASSIGNABLE_REQUIRED = "COMPILER-70";
    public static final String ELVIS_NOT_NULLABLE = "COMPILER-71";
    public static final String ELVIS_ONLY_NULLABLE = "COMPILER-72";
    public static final String SHORT_CIRCUIT_ILLEGAL = "COMPILER-73";
    public static final String SHORT_CIRCUIT_REQUIRED = "COMPILER-74";
    public static final String SWITCH_DEFAULT_DUPLICATE = "COMPILER-75";
    public static final String SWITCH_DEFAULT_REQUIRED = "COMPILER-76";
    public static final String SWITCH_CASE_DUPLICATE = "COMPILER-77";
    public static final String SWITCH_CASE_CONSTANT_REQUIRED = "COMPILER-78";
    public static final String SWITCH_CASE_EXPECTED = "COMPILER-79";
    public static final String SWITCH_CASE_DANGLING = "COMPILER-80";
    public static final String VAR_UNASSIGNED = "COMPILER-81";
    public static final String VAR_ASSIGNMENT_ILLEGAL = "COMPILER-82";
    public static final String NAME_REQUIRED = "COMPILER-83";
    public static final String ARGUMENT_WRONG_COUNT = "COMPILER-84";
    public static final String DUPLICATE_PARAMETER = "COMPILER-85";
    public static final String PARAMETER_TYPES_REQUIRED = "COMPILER-86";
    public static final String AUTO_NARROWING_ILLEGAL = "COMPILER-87";
    public static final String MISSING_GOTO_LABEL = "COMPILER-88";
    public static final String MISSING_GOTO_TARGET = "COMPILER-89";
    public static final String ILLEGAL_CONTINUE_TARGET = "COMPILER-90";
    public static final String EXPRESSION_NOT_NULLABLE = "COMPILER-91";
    public static final String TYPES_NOT_COMPARABLE = "COMPILER-92";
    public static final String DUPLICATE_LABEL = "COMPILER-93";
    public static final String LABEL_VARIABLE_ILLEGAL = "COMPILER-94";
    public static final String INVALID_LVALUE_COUNT = "COMPILER-95";
    public static final String INVALID_INDEX = "COMPILER-95";
    public static final String INVALID_ANON_CLASS_TYPE = "COMPILER-96";
    public static final String ANON_CLASS_EXTENDS_MULTI = "COMPILER-97";
    public static final String ANON_CLASS_EXTENDS_ILLEGAL = "COMPILER-98";
    public static final String ANON_CLASS_MUTABILITY_CONFUSED = "COMPILER-99";
    public static final String ANON_CLASS_EXTENDS_UNION = "COMPILER-100";
    public static final String IMPLICIT_PROP_MISSING = "COMPILER-101";
    public static final String IMPLICIT_PROP_WRONG_TYPE = "COMPILER-102";
    public static final String IMPLICIT_SUPER_CONSTRUCTOR_MISSING = "COMPILER-103";
    public static final String INVALID_SUPER_REFERENCE = "COMPILER-104";
    public static final String IMPORT_NAME_COLLISION = "COMPILER-105";
    public static final String IMPORT_NOT_IDENTITY = "COMPILER-106";
    public static final String NO_THIS_PROPERTY = "COMPILER-107";
    public static final String NO_THIS_METHOD = "COMPILER-108";
    public static final String VIRTUAL_CHILD_OVERRIDE_MISSING = "COMPILER-109";
    public static final String VIRTUAL_CHILD_OVERRIDE_ILLEGAL = "COMPILER-110";
    public static final String VIRTUAL_CHILD_EXTENDS_ILLEGAL = "COMPILER-111";
    public static final String VIRTUAL_CHILD_EXTENDS_CLASS = "COMPILER-112";
    public static final String VIRTUAL_CHILD_EXTENDS_IMPLICIT = "COMPILER-113";
    public static final String VIRTUAL_CHILD_EXTENDS_INTERFACE = "COMPILER-114";
    public static final String VIRTUAL_CHILD_EXTENDS_MULTIPLE = "COMPILER-115";
    public static final String SWITCH_CASE_ILLEGAL_ARITY = "COMPILER-116";
    public static final String SWITCH_BREAK_OR_CONTINUE_EXPECTED = "COMPILER-117";
    public static final String CATCH_TYPE_ALREADY_CAUGHT = "COMPILER-118";
    public static final String STATIC_PROP_IN_METHOD_HAS_ACCESS = "COMPILER-119";
    public static final String PROP_IN_METHOD_NOT_PRIVATE = "COMPILER-120";
    public static final String STATIC_PROP_HAS_SETTER_ACCESS = "COMPILER-121";
    public static final String PROP_SETTER_ACCESS_TOO_ACCESSIBLE = "COMPILER-122";
    public static final String NO_DEFAULT_VALUE = "COMPILER-123";
    public static final String NAME_RESERVED = "COMPILER-124";
    public static final String FUNCTION_NOT_ALLOWED = "COMPILER-125";
    public static final String FUNCTION_BODY_MISSING = "COMPILER-126";
    public static final String ILLEGAL_FUNKY_CALL = "COMPILER-127";
    public static final String ILLEGAL_WHILE_CONDITION = "COMPILER-128";
    public static final String ILLEGAL_INVOCATION = "COMPILER-129";
    public static final String SHORT_CIRCUIT_ALWAYS_NULL = "COMPILER-130";
    public static final String DELEGATE_PROP_MISSING = "COMPILER-131";
    public static final String DELEGATE_PROP_WRONG_TYPE = "COMPILER-132";
    public static final String DUPLICATE_METHOD = "COMPILER-133";
    public static final String NOT_TYPE_OF_TYPE = "COMPILER-134";
    public static final String INVALID_FORMAL_TYPE_IDENTITY = "COMPILER-135";
    public static final String UNSUPPORTED_DYNAMIC_TYPE_PARAMS = "COMPILER-136";
    public static final String TYPE_MATCHES_ALWAYS = "COMPILER-137";
    public static final String SUSPICIOUS_FUNCTION_USE = "COMPILER-138";
    public static final String CONDITIONAL_RETURN_NOT_ALLOWED = "COMPILER-139";
    public static final String ANNOTATION_NOT_APPLICABLE = "COMPILER-140";
    public static final String ILLEGAL_ARG_NAME = "COMPILER-141";
    public static final String METHOD_NAME_COLLISION = "COMPILER-142";
    public static final String PROPERTY_NAME_COLLISION = "COMPILER-143";
    public static final String GENERIC_FUNCTION_TYPE_NOT_ALLOWED = "COMPILER-144";
    public static final String TYPE_PARAMS_UNRESOLVABLE = "COMPILER-145";
    public static final String INVALID_PROPERTY_REF = "COMPILER-146";
    public static final String VALIDATOR_BODY_MISSING = "COMPILER-147";
    public static final String DUPLICATE_NAME = "COMPILER-148";
    public static final String PARENT_NOT_CONSTRUCTED = "COMPILER-149";
    public static final String INCOMPATIBLE_PARAMETER_TYPE = "COMPILER-150";
    public static final String INCOMPATIBLE_RETURN_TYPE = "COMPILER-151";
    public static final String INCOMPATIBLE_RETURN_COUNT = "COMPILER-152";
    public static final String DEFAULT_VALUE_REQUIRED = "COMPILER-153";
    public static final String MAP_KEYS_DUPLICATE = "COMPILER-154";
    public static final String INFINITE_LOOP = "COMPILER-155";
    public static final String INVALID_CONSTRUCT_CALL = "COMPILER-156";
    public static final String SUPER_CONSTRUCTOR_SKIPPED = "COMPILER-157";
    public static final String ASSERT_EXPRESSION_MUST_THROW = "COMPILER-158";
    public static final String NO_OUTER_PROPERTY = "COMPILER-159";
    public static final String NO_OUTER_METHOD = "COMPILER-160";
    public static final String ILLEGAL_VIRTUAL_CONSTRUCTOR = "COMPILER-161";
    public static final String PROPERTY_INACCESSIBLE = "COMPILER-162";
    public static final String BAD_LITERAL = "COMPILER-163";
    public static final String SET_VALUES_DUPLICATE = "COMPILER-164";
    public static final String ANNOTATED_INJECTION = "COMPILER-165";
    public static final String GENERIC_PROPERTY_TYPE_NOT_ALLOWED = "COMPILER-166";
    public static final String ASYNC_NOT_ALLOWED = "COMPILER-167";
    public static final String SWITCH_TYPES_NONUNIFORM = "COMPILER-168";
    public static final String NEW_ABSTRACT_TYPE = "COMPILER-169";
    public static final String NEW_SINGLETON_TYPE = "COMPILER-170";
    public static final String NEW_ABSTRACT_PROPERTY = "COMPILER-171";
    public static final String NEW_ABSTRACT_METHOD = "COMPILER-172";
    public static final String NEW_ABSTRACT_CHILD_PROPERTY = "COMPILER-173";
    public static final String NEW_ABSTRACT_CHILD_METHOD = "COMPILER-174";
    public static final String NEW_UNRELATED_PARENT = "COMPILER-175";
    public static final String INVALID_CALL_FROM_CONSTRUCT = "COMPILER-176";
    public static final String METHOD_INACCESSIBLE = "COMPILER-177";
    public static final String SUSPICIOUS_PROPERTY_USE = "COMPILER-178";
    public static final String TYPE_PARAMS_INACCESSIBLE = "COMPILER-179";
    public static final String EXPRESSION_NOT_STATEMENT = "COMPILER-180";
    public static final String SWITCH_OVERFLOW = "COMPILER-181";
    public static final String METHOD_BODY_MISSING = "COMPILER-182";
    public static final String NEW_INVALID_FORMAL = "COMPILER-183";
    public static final String AMBIGUOUS_PATH_TYPE = "COMPILER-184";
    public static final String CIRCULAR_INITIALIZER = "COMPILER-185";
    public static final String NON_VIRTUAL_SUPER = "COMPILER-186";
    public static final String TYPE_MATCHES_NEVER = "COMPILER-187";
    public static final String CONTRIBUTION_PARAMS_UNEXPECTED = "COMPILER-188";
    public static final String PROPERTY_NAME_RESERVED = "COMPILER-189";
    public static final String PROPERTY_TYPE_COLLISION = "COMPILER-190";
    public static final String SWITCH_CONTINUE_NOT_EXPECTED = "COMPILER-191";
    public static final String SINGLETON_REQUIRED = "COMPILER-192";
    public static final String INJECTOR_REQUIRED = "COMPILER-193";
    public static final String DELEGATE_INVALID = "COMPILER-194";
    public static final String SUPER_MISSING = "COMPILER-195";
    public static final String TRY_WITHOUT_CATCH = "COMPILER-196";
    public static final String WRITEABLE_CAPTURE = "COMPILER-197";
    public static final String INVALID_ANNOTATIONS_COMBO = "COMPILER-198";
    public static final String MISSING_RESOURCE = "COMPILER-199";
    public static final String MISSING_PARAM_RESOURCE = "COMPILER-200";
    public static final String PROP_SELF_ASSIGNED = "COMPILER-201";
    public static final String PROP_READONLY_INIT = "COMPILER-202";
    public static final String PARENT_MISSING = "COMPILER-203";
    public static final String NOT_IMPLEMENTED = "COMPILER-NI";

    public Compiler(TypeCompositionStatement stmtModule, ErrorList errs) {
        if (stmtModule == null) {
            throw new IllegalArgumentException("AST node for module required");
        }
        if (stmtModule.getCategory().getId() != Token.Id.MODULE) {
            throw new IllegalArgumentException("AST node for module is not a module statement");
        }
        if (errs == null) {
            throw new IllegalArgumentException("ErrorList required");
        }
        this.m_stmtModule = stmtModule;
        this.m_errs = errs;
    }

    public TypeCompositionStatement getModuleStatement() {
        this.validateCompiler();
        return this.m_stmtModule;
    }

    public ErrorList getErrorListener() {
        this.validateCompiler();
        return this.m_errs;
    }

    public FileStructure getFileStructure() {
        this.validateCompiler();
        return this.m_structFile;
    }

    public Stage getStage() {
        return this.m_stage;
    }

    public boolean alreadyReached(Stage stage) {
        this.validateCompiler();
        assert (stage != null);
        return this.getStage().compareTo(stage) >= 0;
    }

    public boolean isAbortDesired() {
        return this.m_errs.isAbortDesired();
    }

    public FileStructure generateInitialFileStructure() {
        this.validateCompiler();
        if (this.getStage() == Stage.Initial) {
            this.setStage(Stage.Registering);
            StageMgr mgr = new StageMgr(this.m_stmtModule, Stage.Registered, (ErrorListener)this.m_errs);
            if (!mgr.processComplete()) {
                if (this.m_errs.hasSeriousErrors()) {
                    return null;
                }
                throw new CompilerException("failed to create module");
            }
            this.m_structFile = this.m_stmtModule.getComponent().getFileStructure();
            this.m_structFile.setErrorListener(ErrorListener.BLACKHOLE);
            this.setStage(Stage.Registered);
        }
        return this.m_structFile;
    }

    public ModuleConstant linkModules(ModuleRepository repo) {
        this.validateCompiler();
        this.ensureReached(Stage.Registered);
        if (this.alreadyReached(Stage.Loaded)) {
            return null;
        }
        try (Auto ignore = ConstantPool.withPool(this.m_structFile.getConstantPool());){
            this.setStage(Stage.Loading);
            ModuleConstant idMissing = this.m_structFile.linkModules(repo, false);
            if (idMissing == null) {
                this.setStage(Stage.Loaded);
            }
            ModuleConstant moduleConstant = idMissing;
            return moduleConstant;
        }
    }

    public boolean resolveNames(boolean fLastAttempt) {
        this.validateCompiler();
        this.ensureReached(Stage.Registered);
        if (this.alreadyReached(Stage.Resolved)) {
            return true;
        }
        try (Auto ignore = ConstantPool.withPool(this.m_structFile.getConstantPool());){
            if (!this.alreadyReached(Stage.Resolving)) {
                this.setStage(Stage.Resolving);
                this.m_mgr = new StageMgr(this.m_stmtModule, Stage.Resolved, (ErrorListener)this.m_errs);
            }
            if (fLastAttempt) {
                this.m_mgr.markLastAttempt();
            }
            if (this.m_mgr.processComplete()) {
                this.setStage(Stage.Resolved);
            }
        }
        return this.m_mgr.isComplete();
    }

    public boolean validateExpressions(boolean fLastAttempt) {
        this.validateCompiler();
        this.ensureReached(Stage.Resolved);
        if (this.alreadyReached(Stage.Validated)) {
            return true;
        }
        try (Auto ignored = ConstantPool.withPool(this.m_structFile.getConstantPool());){
            if (!this.alreadyReached(Stage.Validating)) {
                this.setStage(Stage.Validating);
                this.m_mgr = new StageMgr(this.m_stmtModule, Stage.Validated, (ErrorListener)this.m_errs);
            }
            if (fLastAttempt) {
                this.m_mgr.markLastAttempt();
            }
            if (this.m_mgr.processComplete()) {
                this.setStage(Stage.Validated);
            }
        }
        return this.m_mgr.isComplete();
    }

    public boolean generateCode(boolean fLastAttempt) {
        this.validateCompiler();
        this.ensureReached(Stage.Validated);
        if (this.alreadyReached(Stage.Emitted)) {
            return true;
        }
        try (Auto ignored = ConstantPool.withPool(this.m_structFile.getConstantPool());){
            if (!this.alreadyReached(Stage.Emitting)) {
                this.setStage(Stage.Emitting);
                this.m_mgr = new StageMgr(this.m_stmtModule, Stage.Emitted, (ErrorListener)this.m_errs);
            }
            if (fLastAttempt) {
                this.m_mgr.markLastAttempt();
            }
            if (this.m_mgr.processComplete()) {
                this.setStage(Stage.Emitted);
                if (this.m_errs.getSeverity().compareTo(Severity.ERROR) < 0) {
                    this.m_structFile.reregisterConstants(true);
                    this.m_structFile.validate(this.m_errs);
                    this.m_structFile.setErrorListener(null);
                }
            }
        }
        return this.m_mgr.isComplete();
    }

    public void logRemainingDeferredAsErrors() {
        if (!this.m_errs.hasSeriousErrors()) {
            this.m_mgr.logDeferredAsErrors(this.m_errs);
        }
    }

    public void invalidate() {
        this.setStage(Stage.Discarded);
    }

    public String toString() {
        return "Compiler (Module=" + this.m_stmtModule.getName() + ", Stage=" + String.valueOf((Object)this.getStage()) + ")";
    }

    private void validateCompiler() {
        if (this.getStage() == Stage.Discarded) {
            throw new IllegalStateException();
        }
    }

    private void ensureReached(Stage stage) {
        if (!this.alreadyReached(stage)) {
            throw new IllegalStateException("Stage=" + String.valueOf((Object)this.getStage()) + " (expected: " + String.valueOf((Object)stage) + ")");
        }
    }

    private void setStage(Stage stage) {
        if (stage != null && stage.compareTo(this.m_stage) > 0) {
            this.m_stage = stage;
        }
    }

    public static enum Stage {
        Initial,
        Registering,
        Registered,
        Loading,
        Loaded,
        Resolving,
        Resolved,
        Validating,
        Validated,
        Emitting,
        Emitted,
        Discarded;

        private static final Stage[] STAGES;

        public boolean isTargetable() {
            this.ensureValid();
            int n = this.ordinal();
            return (n & 1) == 0 && n > 0;
        }

        public boolean isTransition() {
            this.ensureValid();
            return (this.ordinal() & 1) == 1;
        }

        public Stage getTransitionStage() {
            this.ensureValid();
            return this.isTransition() ? this : this.prev();
        }

        public boolean isAtLeast(Stage that) {
            this.ensureValid();
            return this.compareTo(that) >= 0;
        }

        public void ensureValid() {
            if (this == Discarded) {
                throw new IllegalStateException();
            }
        }

        public Stage prev() {
            this.ensureValid();
            return Stage.valueOf(this.ordinal() - 1);
        }

        public Stage next() {
            this.ensureValid();
            return Stage.valueOf(this.ordinal() + 1);
        }

        public Stage prevTarget() {
            Stage that = this.prev();
            while (!that.isTargetable()) {
                that = that.prev();
            }
            return that;
        }

        public Stage nextTarget() {
            Stage that = this.next();
            while (!that.isTargetable()) {
                that = that.next();
            }
            return that;
        }

        public static Stage valueOf(int i) {
            if (i >= 0 && i < STAGES.length) {
                return STAGES[i];
            }
            throw new IllegalArgumentException("no such stage ordinal: " + i);
        }

        static {
            STAGES = Stage.values();
        }
    }
}

