/*
 * Decompiled with CFR 0.152.
 */
package org.xvm.compiler;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xvm.asm.Argument;
import org.xvm.asm.Assignment;
import org.xvm.asm.ClassStructure;
import org.xvm.asm.Component;
import org.xvm.asm.ComponentResolver;
import org.xvm.asm.ConstantPool;
import org.xvm.asm.Constants;
import org.xvm.asm.ErrorList;
import org.xvm.asm.ErrorListener;
import org.xvm.asm.MethodStructure;
import org.xvm.asm.MultiMethodStructure;
import org.xvm.asm.Parameter;
import org.xvm.asm.Register;
import org.xvm.asm.constants.PropertyInfo;
import org.xvm.asm.constants.TypeConstant;
import org.xvm.compiler.Compiler;
import org.xvm.compiler.Parser;
import org.xvm.compiler.Source;
import org.xvm.compiler.Token;
import org.xvm.compiler.ast.Context;
import org.xvm.compiler.ast.MethodDeclarationStatement;
import org.xvm.compiler.ast.StageMgr;
import org.xvm.compiler.ast.StatementBlock;
import org.xvm.compiler.ast.TypeExpression;
import org.xvm.runtime.Frame;
import org.xvm.runtime.ObjectHandle;
import org.xvm.runtime.Utils;
import org.xvm.util.ListMap;
import org.xvm.util.Severity;

public class EvalCompiler {
    private int[] m_aiArg;
    private final Frame f_frame;
    private final Source f_source;
    private ErrorList m_errs;

    public EvalCompiler(Frame frame, String sMethod) {
        this.f_frame = frame;
        this.f_source = new Source(sMethod);
    }

    public MethodStructure createLambda(TypeConstant typeReturn) {
        ConstantPool pool = this.f_frame.poolContext();
        ErrorList errs = this.m_errs = new ErrorList(1);
        MethodStructure method = this.f_frame.f_function;
        ClassStructure clz = method.getContainingClass();
        MultiMethodStructure mms = clz.ensureMultiMethodStructure("->");
        MethodStructure lambda = mms.createLambda(TypeConstant.NO_TYPES, Utils.NO_NAMES);
        TypeConstant[] atypeRets = new TypeConstant[]{pool.typeObject()};
        Parameter[] aparamRets = new Parameter[]{new Parameter(pool, typeReturn, null, null, true, 0, false)};
        lambda.configureLambda(Parameter.NO_PARAMS, 0, aparamRets);
        lambda.setStatic(method.isFunction());
        lambda.createCode();
        try {
            StatementBlock astBody = new Parser(this.f_source, errs).parseStatementBlock();
            EvalStatement astMethod = new EvalStatement(this.f_frame, lambda, astBody);
            StageMgr mgr = new StageMgr(astMethod, Compiler.Stage.Registered, (ErrorListener)errs);
            if (!mgr.processComplete()) {
                return null;
            }
            mgr = new StageMgr(astMethod, Compiler.Stage.Loaded, (ErrorListener)errs);
            if (!mgr.processComplete()) {
                return null;
            }
            mgr = new StageMgr(astMethod, Compiler.Stage.Resolved, (ErrorListener)errs);
            if (!mgr.processComplete()) {
                return null;
            }
            mgr = new StageMgr(astMethod, Compiler.Stage.Validated, (ErrorListener)errs);
            if (!mgr.processComplete()) {
                return null;
            }
            mgr = new StageMgr(astMethod, Compiler.Stage.Emitted, (ErrorListener)errs);
            if (!mgr.processComplete() || errs.hasSeriousErrors()) {
                return null;
            }
            Map<String, Argument> mapCaptures = astMethod.getCaptures();
            int cParams = mapCaptures.size();
            TypeConstant[] atypeParams = new TypeConstant[cParams];
            Parameter[] aparamParams = new Parameter[cParams];
            int ix = 0;
            for (Map.Entry<String, Argument> entry : mapCaptures.entrySet()) {
                TypeConstant type;
                String sName = entry.getKey();
                atypeParams[ix] = type = entry.getValue().getType();
                aparamParams[ix] = new Parameter(pool, type, sName, null, false, ix, false);
                ++ix;
            }
            lambda.configureLambda(aparamParams, 0, aparamRets);
            lambda.getIdentityConstant().setSignature(pool.ensureSignatureConstant("->", atypeParams, atypeRets));
            lambda.setAst(lambda.getAst(), astMethod.f_ctx.collectParameters());
            lambda.forceAssembly(pool);
            this.m_aiArg = astMethod.getArguments();
            return lambda;
        }
        catch (Exception e) {
            if (!errs.hasSeriousErrors()) {
                errs.log(Severity.FATAL, "PARSER-01", null, this.f_source, this.f_source.getPosition(), this.f_source.getPosition());
            }
            return null;
        }
    }

    public List<ErrorListener.ErrorInfo> getErrors() {
        return this.m_errs.getErrors();
    }

    public int[] getArgs() {
        return this.m_aiArg;
    }

    protected class EvalStatement
    extends MethodDeclarationStatement
    implements ComponentResolver {
        private final Frame f_frame;
        private final EvalContext f_ctx;
        private static final Field[] CHILD_FIELDS = EvalStatement.fieldsForNames(MethodDeclarationStatement.class, "body");

        public EvalStatement(Frame frame, MethodStructure lambda, StatementBlock body) {
            super(lambda, body);
            this.f_frame = frame;
            this.f_ctx = new EvalContext(frame, body, lambda);
        }

        public Map<String, Argument> getCaptures() {
            return this.f_ctx.f_mapCapture;
        }

        public int[] getArguments() {
            List<Integer> listIndex = this.f_ctx.f_listRegisters;
            int cArgs = listIndex.size();
            int[] aIndex = new int[cArgs];
            for (int i = 0; i < cArgs; ++i) {
                aIndex[i] = listIndex.get(i);
            }
            return aIndex;
        }

        @Override
        public Source getSource() {
            return EvalCompiler.this.f_source;
        }

        @Override
        public ComponentResolver getComponentResolver() {
            return this;
        }

        @Override
        public boolean isAutoNarrowingAllowed(TypeExpression type) {
            return false;
        }

        @Override
        protected void registerStructures(StageMgr mgr, ErrorListener errs) {
            this.introduceParentage();
            mgr.processChildrenExcept(child -> child == this.body);
        }

        @Override
        public void resolveNames(StageMgr mgr, ErrorListener errs) {
            mgr.deferChildren();
        }

        @Override
        protected void compileBody(StageMgr mgr, MethodStructure method, ErrorListener errs) {
            this.body.compileMethod(this.f_ctx, method.ensureCode(), errs);
        }

        @Override
        public ConstantPool pool() {
            return this.f_frame.poolContext();
        }

        @Override
        protected boolean canResolveNames() {
            return true;
        }

        @Override
        protected Field[] getChildFields() {
            return CHILD_FIELDS;
        }

        @Override
        public ComponentResolver.ResolutionResult resolveName(String sName, Constants.Access access, ComponentResolver.ResolutionCollector collector) {
            Component component = this.pool().getImplicitlyImportedComponent(sName);
            return component == null ? ComponentResolver.ResolutionResult.ERROR : collector.resolvedComponent(component);
        }

        @Override
        public String toString() {
            return "EvalStatement";
        }
    }

    protected static class EvalContext
    extends StatementBlock.RootContext {
        public final List<Integer> f_listRegisters = new ArrayList<Integer>();
        private final Frame f_frame;
        public final Map<String, Argument> f_mapCapture = new ListMap<String, Argument>();

        public EvalContext(Frame frame, StatementBlock stmt, MethodStructure lambda) {
            super(stmt, lambda);
            this.f_frame = frame;
        }

        @Override
        public TypeConstant getThisType() {
            ConstantPool pool = this.pool();
            MethodStructure function = this.f_frame.f_function;
            if (function.isFunction()) {
                return pool.ensureAccessTypeConstant(super.getThisType(), Constants.Access.PRIVATE);
            }
            ClassStructure clz = function.getContainingClass();
            TypeConstant type = clz.getFormalType().resolveGenerics(pool, this.f_frame.getThis().getType());
            return pool.ensureAccessTypeConstant(type, Constants.Access.PRIVATE);
        }

        @Override
        protected Argument resolveRegularName(Context ctxFrom, String sName, Token name, ErrorListener errs) {
            Argument arg = super.resolveRegularName(ctxFrom, sName, name, errs);
            if (arg == null) {
                try {
                    ObjectHandle objectHandle;
                    if (!this.f_frame.f_function.isFunction() && (objectHandle = this.f_frame.getArgument(-9)) instanceof ObjectHandle.GenericHandle) {
                        ObjectHandle.GenericHandle hThis = (ObjectHandle.GenericHandle)objectHandle;
                        ClassStructure clz = this.getThisClass();
                        MultiMethodStructure mms = (MultiMethodStructure)clz.findChildDeep(sName);
                        if (mms != null) {
                            arg = new StatementBlock.TargetInfo(sName, mms.getIdentityConstant(), true, this.getThisType(), 0);
                            this.ensureNameMap().put(sName, arg);
                            return arg;
                        }
                        clz = (ClassStructure)hThis.getType().getSingleUnderlyingClass(true).getComponent();
                        mms = (MultiMethodStructure)clz.findChildDeep(sName);
                        if (mms != null) {
                            arg = new StatementBlock.TargetInfo(sName, mms.getIdentityConstant(), true, hThis.getType(), 0);
                            this.ensureNameMap().put(sName, arg);
                            return arg;
                        }
                    }
                }
                catch (ObjectHandle.ExceptionHandle.WrapperException wrapperException) {
                    // empty catch block
                }
            }
            return arg;
        }

        @Override
        public ConstantPool pool() {
            return this.f_frame.poolContext();
        }

        @Override
        public ClassStructure getEnclosingClass() {
            return this.getMethod().getContainingClass();
        }

        @Override
        public boolean isAnonInnerClass() {
            return this.getEnclosingClass().isAnonInnerClass();
        }

        @Override
        protected Argument getLocalVar(String sName, Context.Branch branch) {
            Object info;
            Argument arg = this.getNameMap().get(sName);
            if (arg != null) {
                return arg;
            }
            Frame.VarInfo[] aInfo = this.f_frame.f_aInfo;
            int cVars = this.f_frame.getCurrentVarCount();
            for (int iVar = 0; iVar < cVars; ++iVar) {
                info = aInfo[iVar];
                if (info == null || !((Frame.VarInfo)info).getName().equals(sName)) continue;
                Register reg = new Register(((Frame.VarInfo)info).getType(), null, this.f_listRegisters.size());
                this.f_mapCapture.put(sName, reg);
                this.f_listRegisters.add(iVar);
                this.ensureNameMap().put(sName, reg);
                this.ensureDefiniteAssignments().put(sName, Assignment.AssignedOnce);
                return reg;
            }
            if (!this.f_frame.f_function.isFunction()) {
                if ("this".equals(sName)) {
                    Register reg = this.getThisRegister();
                    this.ensureNameMap().put(sName, reg);
                    return reg;
                }
                info = this.f_frame.getThis().ensureAccess(Constants.Access.PRIVATE);
                if (info instanceof ObjectHandle.GenericHandle) {
                    ObjectHandle.GenericHandle hThis = (ObjectHandle.GenericHandle)info;
                    TypeConstant type = this.getThisType();
                    PropertyInfo prop = type.ensureTypeInfo().findProperty(sName);
                    if (prop != null) {
                        arg = prop.getIdentity();
                        this.ensureNameMap().put(sName, arg);
                        return arg;
                    }
                    type = hThis.getType();
                    prop = type.ensureTypeInfo().findProperty(sName);
                    if (prop != null) {
                        arg = prop.getIdentity();
                        this.ensureNameMap().put(sName, arg);
                        return arg;
                    }
                }
            }
            return null;
        }
    }
}

